/*************************************************************************
 *                                                                       *
 *                   CS 312 GUI for PS4 Spring 2008                      *
 *                  Copyright 2008 by  Paul Lewellen                     *
 *                                                                       *
 * This program is free software: you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation, either version 2 of the License, or     *
 * (at your option) any later version.                                   *
 *                                                                       *
 * This program is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 * GNU General Public License for more details.                          *
 *                                                                       *
 * You should have received a copy of the GNU General Public License     *
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 *                                                                       *
 *       Usage: ps4gui [<scaled window width> <scale window height>]     *
 *                                                                       *
 *************************************************************************/

#define NO_STDIO_REDIRECT

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <SDL.h>
#include <SDL_net.h>
#include <SDL_opengl.h>

const int port=3124;           //TCP port to listen on
const int resX=512, resY=512;  //Actual resolution of screen to draw on.
const int bufferSize = 512;    //Maximum length of a single drawing command

//Sets pixel at (x,y) to color defined by ints R,G,B
void drawRect(int x1, int y1, int x2, int y2, int r, int g, int b);
//Adds next incoming char to string, returns true if end of string reached
bool getCommand(char str[], SDLNet_SocketSet set, TCPsocket &sock);

int main(int argc, char *argv[]) {
  int screenX=512, screenY=512;
  SDL_Surface *screen = NULL;
  SDL_Event test_event;
  IPaddress ip;
  TCPsocket serversock;
  TCPsocket sock = NULL;
  SDLNet_SocketSet tcpset = NULL;
  bool running =true;
  int x1,y1,x2,y2,r,g,b;
  char cmd[bufferSize]="\0";

  if (argc==3) {
    sscanf(argv[1],"%i",&screenX);
    sscanf(argv[2],"%i",&screenY);
    printf("Setting Display Resolution to %i x %i\n",screenX,screenY);
  }
  if (SDL_Init(SDL_INIT_VIDEO)) {
    printf("Unable to initialize SDL Graphics subsystem.\n");
    printf("SDL_Init: %s\n", SDL_GetError());
    exit(1);
  }
  if(SDLNet_Init()==-1) {
    printf("SDLNet_Init Failure: %s\n", SDLNet_GetError());
    SDL_Quit();
    exit(2);
  }
  if(SDLNet_ResolveHost(&ip,NULL,port)==-1) {
    printf("SDLNet_ResolveHost Failure: %s\n",SDLNet_GetError());
    exit(2);
  }
  serversock=SDLNet_TCP_Open(&ip);
  if(!serversock) {
    printf("SDLNet_TCP_Open Failure: %s\n", SDLNet_GetError());
    exit(2);
  }

  SDL_GL_SetAttribute( SDL_GL_DOUBLEBUFFER, true );
  screen = SDL_SetVideoMode(screenX, screenY, 32, SDL_OPENGL);
  if (!screen) {
    printf("Unable to create desired screen: %s\n", SDL_GetError());
    SDLNet_Quit();
    SDL_Quit();
    exit(3);
  }
  SDL_WM_SetCaption("CS312 PS4 GUI","CS312 PS4 GUI");

  glClearColor( 0.0f, 0.0f, 0.0f, 0.0f );
 
  glViewport( 0, 0, screenX, screenY );
  
  glMatrixMode( GL_PROJECTION );
  glLoadIdentity();
  
  glOrtho(-0.5f, resX-0.5f, resY-0.5f, -0.5f, -1.0f, 1.0f);
  
  glMatrixMode( GL_MODELVIEW );
 
  glLoadIdentity();
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  while (running) {
    while (SDL_PollEvent(&test_event)) {
      switch (test_event.type) {
       case SDL_KEYDOWN:
	running = (test_event.key.keysym.sym != SDLK_ESCAPE);
	break;
       case SDL_QUIT:
	running = false;
      case SDL_VIDEOEXPOSE: //A dirty window forces a buffer-flip
        glFlush();
        SDL_GL_SwapBuffers();
      }
    }
    if (!sock) {
      if (tcpset) {
	SDLNet_FreeSocketSet(tcpset);
	tcpset=NULL;
      }
      if (sock=SDLNet_TCP_Accept(serversock)) {
	tcpset = SDLNet_AllocSocketSet(1);
	SDLNet_TCP_AddSocket(tcpset,sock);
	printf("Connection Established.\n");
      } 
    } else if (getCommand(cmd, tcpset, sock)) {
      switch(cmd[0]) {
      case 'P': //Set Pixel
	if (sscanf(cmd,"%*s %d %d %d %d %d",&x1,&y1,&r,&g,&b) == 5)
	  drawRect(x1,y1,x1,y1,r,g,b);
	else
	  printf("Invalid Pixel Command: \"%s\"\n", cmd);
	break;
      case 'R': //Draw Filled Rectangle
	if (sscanf(cmd,"%*s %d %d %d %d %d %d %d",&x1,&y1,&x2,&y2,&r,&g,&b)==7)
	  drawRect(x1,y1,x2,y2,r,g,b);
	else
	  printf("Invalid Rectangle Command: \"%s\"\n", cmd);
	break;
      case 'C': //Clear Screen
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	break;
      case 'F': //Flip Buffers
	glFlush();
	SDL_GL_SwapBuffers();
	break;
      default:
	printf("Ignoring Unknown Command: \"%s\"\n", cmd);
      }
      cmd[0]='\0';
    }
  }
  SDL_Quit();
  return(0);
}


void drawRect(int x1, int y1, int x2, int y2, int r, int g, int b) {
  glColor3f(r/255.0,g/255.0,b/255.0);
  glBegin(GL_TRIANGLE_STRIP);
    glVertex3f(x1-0.501,y1-0.501,0.0);
    glVertex3f(x2+0.501,y1-0.501,0.0);
    glVertex3f(x1-0.501,y2+0.501,0.0);
    glVertex3f(x2+0.501,y2+0.501,0.0);
  glEnd();
}

bool getCommand(char str[], SDLNet_SocketSet set, TCPsocket &sock) {
  int tmp=SDLNet_CheckSockets(set,100);
  if (tmp==-1) {
    printf("Error polling tcp socket.\n");
    SDLNet_Quit();
    SDL_Quit();
    exit(2);
  }
  if (tmp) {
    int len=strlen(str);
    if (len==bufferSize-1) {
      printf("Error Reading from Socket - Command Too Long.\n");
      SDLNet_TCP_Close(sock);
      sock=NULL;
      str[0]='\0';
      return false;
    }
    if (SDLNet_TCP_Recv(sock,str+len,1)!=1) {
      printf("Error Reading from Socket - Connection Closed.\n");
      SDLNet_TCP_Close(sock);
      sock=NULL;
      str[0]='\0';
      return false;
    }
    str[len+1]='\0';
    if (str[len]=='\n' || str[len]=='\r') str[len]='\0';
    return (str[len]=='\0' && len>0);
  }
  return false;
}
