(* REP loop: a simple loop which reads input, evaluates it, and prints the result. *)
structure ReadEvalPrint = struct

  (* Takes a string, parses it, type checks it, then evaluates it.
   * Useful for testing your code directly. *)
  fun evaluateString(s:string):AbstractSyntaxTree.value = let
    val ast = Parser.parseString s
    val _ = TypeChecker.get_type(ast, TypeChecker.empty_typenv)
  in
    Evaluator.eval(ast, AbstractSyntaxTree.empty_env)
  end

  (* never exits. *)
  fun loop():unit = let
    val () = print("MiniML> ")
    val input = TextIO.inputLine TextIO.stdIn
  in
    if (String.size input) < 1 then ()   (* exit on EOF (use CTRL + Z) *)
    else if (String.size input) < 2
    then (* dont parse it if line was empty *)
         loop() 
    else 
        let 
          val outputValue = evaluateString input
        in
          (print ((PrettyPrinter.value2str outputValue) ^ "\n");
           loop())
        end
  end handle TypeChecker.StaticTypeError s => (print ("Type error: " ^ s ^"\n");
                                               loop())
           | Errors.LexicalError s => (print (s ^ "\n"); loop())
           | Errors.ParseError s => (print (s ^ "\n"); loop())

  (* The "main" function.  Call this to start the interactive interpreter. *)
  fun main():unit = 
    (print ("== CS312-2004FA MiniML interpreter ==\n\n" ^
           "Please input each expression on a single line.\n\n");
     loop())

end
