functor MiniMLLexFun(structure Tokens: MiniML_TOKENS
                              structure D :DATA_TYPES)=
   struct
    structure UserDeclarations =
      struct

structure Tokens = Tokens

type pos = int
type svalue = Tokens.svalue
type ('a,'b) token = ('a,'b) Tokens.token
type lexresult= (svalue,pos) token

structure A = Atom

structure Keywords =
    struct
        type pos = int
        type token = (svalue, pos) Tokens.token

        val atomTrue = A.atom "true"
        val atomFalse = A.atom "false"

        fun ident (a,p1,p2) =
          if A.sameAtom (a,atomTrue)
            then Tokens.DATACON ("true",p1,p2)
          else if A.sameAtom (a,atomFalse)
            then Tokens.DATACON ("false",p1,p2)
          else
            Tokens.ID (Atom.toString (a),p1,p2)
        fun mkKW (kw,tk) = (kw, fn (p1:pos,p2:pos) => tk (p1,p2))

        val keywords = map mkKW
          [("int", Tokens.KW_int),
           ("real", Tokens.KW_real),
           ("string",Tokens.KW_string),
           ("char",Tokens.KW_char),
           ("fn",Tokens.KW_fn),
           ("case",Tokens.KW_case),
           ("of",Tokens.KW_of),
           ("let",Tokens.KW_let),
           ("in",Tokens.KW_in),
           ("end",Tokens.KW_end),
           ("val",Tokens.KW_val),
           ("fun",Tokens.KW_fun),
           ("ref",Tokens.KW_ref),
           ("not",Tokens.KW_not),
           ("if", Tokens.KW_if),
           ("then", Tokens.KW_then),
           ("else", Tokens.KW_else),
           ("unit", Tokens.KW_unit)
          ]
    end

structure K = KeywordFn (Keywords)

(* line number *)
val pos = ref 1
fun error (e,l : int,_) =
     (TextIO.output (TextIO.stdOut,
                     String.concat["line ", (Int.toString l), ": ", e, "\n"]);
      raise Fail "")
fun eof () = Tokens.EOF(!pos,!pos)

val charlist = ref ([] : string list)

val commentNesting = ref (0)

fun addString (s) = (charlist :=  s::(!charlist))
fun makeString () = (concat(rev(!charlist)) before charlist:=[])

fun recognizeDataCon (id,p1,p2) =
  case D.isNullCons (id) of
    NONE => K.keyword(id,p1,p2)
  | SOME (b) => if (b)
                  then Tokens.DATACON (id,p1,p2)
                else Tokens.DATACONARG (id,p1,p2)


end (* end of user routines *)
exception LexError (* raised if illegal leaf action tried *)
structure Internal =
	struct

datatype yyfinstate = N of int
type statedata = {fin : yyfinstate list, trans: string}
(* transition & final state table *)
val tab = let
val s = [ 
 (0, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (1, 
"\009\009\009\009\009\009\009\009\009\050\054\009\009\052\009\009\
\\009\009\009\009\009\009\009\009\009\009\009\009\009\009\009\009\
\\050\049\048\046\009\009\009\009\044\043\042\041\040\038\037\009\
\\036\036\036\036\036\036\036\036\036\036\034\033\031\029\027\023\
\\009\021\021\021\021\021\021\021\021\021\021\021\021\021\021\021\
\\021\021\021\021\021\021\021\021\021\021\021\009\009\009\020\019\
\\009\017\017\017\017\017\017\017\017\017\017\017\017\017\017\017\
\\017\017\017\017\017\017\017\017\017\017\017\016\015\014\010\009\
\\009"
),
 (3, 
"\055\055\055\055\055\055\055\055\055\055\060\055\055\059\055\055\
\\055\055\055\055\055\055\055\055\055\055\055\055\055\055\055\055\
\\055\055\058\055\055\055\055\055\055\055\055\055\055\055\055\055\
\\055\055\055\055\055\055\055\055\055\055\055\055\055\055\055\055\
\\055\055\055\055\055\055\055\055\055\055\055\055\055\055\055\055\
\\055\055\055\055\055\055\055\055\055\055\055\055\056\055\055\055\
\\055\055\055\055\055\055\055\055\055\055\055\055\055\055\055\055\
\\055\055\055\055\055\055\055\055\055\055\055\055\055\055\055\055\
\\055"
),
 (5, 
"\061\061\061\061\061\061\061\061\061\061\066\061\061\065\061\061\
\\061\061\061\061\061\061\061\061\061\061\061\061\061\061\061\061\
\\061\061\064\061\061\061\061\061\061\061\061\061\061\061\061\061\
\\061\061\061\061\061\061\061\061\061\061\061\061\061\061\061\061\
\\061\061\061\061\061\061\061\061\061\061\061\061\061\061\061\061\
\\061\061\061\061\061\061\061\061\061\061\061\061\062\061\061\061\
\\061\061\061\061\061\061\061\061\061\061\061\061\061\061\061\061\
\\061\061\061\061\061\061\061\061\061\061\061\061\061\061\061\061\
\\061"
),
 (7, 
"\067\067\067\067\067\067\067\067\067\067\000\067\067\067\067\067\
\\067\067\067\067\067\067\067\067\067\067\067\067\067\067\067\067\
\\067\067\067\067\067\067\067\067\070\067\068\067\067\067\067\067\
\\067\067\067\067\067\067\067\067\067\067\067\067\067\067\067\067\
\\067\067\067\067\067\067\067\067\067\067\067\067\067\067\067\067\
\\067\067\067\067\067\067\067\067\067\067\067\067\067\067\067\067\
\\067\067\067\067\067\067\067\067\067\067\067\067\067\067\067\067\
\\067\067\067\067\067\067\067\067\067\067\067\067\067\067\067\067\
\\067"
),
 (10, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\012\000\
\\011\011\011\011\011\011\011\011\011\011\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (12, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\013\013\013\013\013\013\013\013\013\013\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (17, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\018\000\000\000\000\000\000\000\000\
\\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\000\
\\000\018\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\018\
\\000\018\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\000\000\000\000\000\
\\000"
),
 (21, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\022\000\000\000\000\000\000\000\000\
\\022\022\022\022\022\022\022\022\022\022\000\000\000\000\000\000\
\\000\022\022\022\022\022\022\022\022\022\022\022\022\022\022\022\
\\022\022\022\022\022\022\022\022\022\022\022\000\000\000\000\022\
\\000\022\022\022\022\022\022\022\022\022\022\022\022\022\022\022\
\\022\022\022\022\022\022\022\022\022\022\022\000\000\000\000\000\
\\000"
),
 (23, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\024\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (24, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\026\000\025\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (27, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\028\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (29, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\030\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (31, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\032\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (34, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\035\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (38, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\039\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (44, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\045\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (46, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\047\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (50, 
"\000\000\000\000\000\000\000\000\000\051\051\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\051\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (52, 
"\000\000\000\000\000\000\000\000\000\000\053\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (56, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\057\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (59, 
"\000\000\000\000\000\000\000\000\000\000\060\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (62, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\063\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (65, 
"\000\000\000\000\000\000\000\000\000\000\066\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (68, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\069\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
 (70, 
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\071\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
),
(0, "")]
fun f x = x 
val s = map f (rev (tl (rev s))) 
exception LexHackingError 
fun look ((j,x)::r, i) = if i = j then x else look(r, i) 
  | look ([], i) = raise LexHackingError
fun g {fin=x, trans=i} = {fin=x, trans=look(s,i)} 
in Vector.fromList(map g 
[{fin = [], trans = 0},
{fin = [], trans = 1},
{fin = [], trans = 1},
{fin = [], trans = 3},
{fin = [], trans = 3},
{fin = [], trans = 5},
{fin = [], trans = 5},
{fin = [], trans = 7},
{fin = [], trans = 7},
{fin = [(N 130)], trans = 0},
{fin = [(N 112),(N 130)], trans = 10},
{fin = [(N 33)], trans = 10},
{fin = [], trans = 12},
{fin = [(N 39)], trans = 12},
{fin = [(N 29),(N 130)], trans = 0},
{fin = [(N 86),(N 130)], trans = 0},
{fin = [(N 24),(N 130)], trans = 0},
{fin = [(N 19),(N 130)], trans = 17},
{fin = [(N 19)], trans = 17},
{fin = [(N 60),(N 130)], trans = 0},
{fin = [(N 114),(N 130)], trans = 0},
{fin = [(N 13),(N 19),(N 130)], trans = 21},
{fin = [(N 13),(N 19)], trans = 21},
{fin = [(N 130)], trans = 23},
{fin = [], trans = 24},
{fin = [(N 29)], trans = 0},
{fin = [(N 24)], trans = 0},
{fin = [(N 102),(N 130)], trans = 27},
{fin = [(N 105)], trans = 0},
{fin = [(N 100),(N 130)], trans = 29},
{fin = [(N 98)], trans = 0},
{fin = [(N 107),(N 130)], trans = 31},
{fin = [(N 110)], trans = 0},
{fin = [(N 58),(N 130)], trans = 0},
{fin = [(N 67),(N 130)], trans = 34},
{fin = [(N 65)], trans = 0},
{fin = [(N 33),(N 130)], trans = 10},
{fin = [(N 130)], trans = 12},
{fin = [(N 95),(N 130)], trans = 38},
{fin = [(N 93)], trans = 0},
{fin = [(N 62),(N 130)], trans = 0},
{fin = [(N 90),(N 130)], trans = 0},
{fin = [(N 88),(N 130)], trans = 0},
{fin = [(N 84),(N 130)], trans = 0},
{fin = [(N 82),(N 130)], trans = 44},
{fin = [(N 72)], trans = 0},
{fin = [(N 56),(N 130)], trans = 46},
{fin = [(N 42)], trans = 0},
{fin = [(N 116),(N 130)], trans = 0},
{fin = [(N 69),(N 130)], trans = 0},
{fin = [(N 7),(N 130)], trans = 50},
{fin = [(N 7)], trans = 50},
{fin = [(N 4),(N 130)], trans = 52},
{fin = [(N 4)], trans = 0},
{fin = [(N 4),(N 7)], trans = 50},
{fin = [(N 128),(N 130)], trans = 0},
{fin = [(N 128),(N 130)], trans = 56},
{fin = [(N 126)], trans = 0},
{fin = [(N 123),(N 128),(N 130)], trans = 0},
{fin = [(N 121),(N 128),(N 130)], trans = 59},
{fin = [(N 121)], trans = 0},
{fin = [(N 54),(N 130)], trans = 0},
{fin = [(N 54),(N 130)], trans = 62},
{fin = [(N 52)], trans = 0},
{fin = [(N 49),(N 54),(N 130)], trans = 0},
{fin = [(N 47),(N 54),(N 130)], trans = 65},
{fin = [(N 47)], trans = 0},
{fin = [(N 80),(N 130)], trans = 0},
{fin = [(N 80),(N 130)], trans = 68},
{fin = [(N 75)], trans = 0},
{fin = [(N 80),(N 130)], trans = 70},
{fin = [(N 78)], trans = 0}])
end
structure StartStates =
	struct
	datatype yystartstate = STARTSTATE of int

(* start state definitions *)

val CHAR = STARTSTATE 5;
val COMMENT = STARTSTATE 7;
val INITIAL = STARTSTATE 1;
val STRING = STARTSTATE 3;

end
type result = UserDeclarations.lexresult
	exception LexerError (* raised if illegal leaf action tried *)
end

fun makeLexer yyinput =
let	val yygone0=1
	val yyb = ref "\n" 		(* buffer *)
	val yybl = ref 1		(*buffer length *)
	val yybufpos = ref 1		(* location of next character to use *)
	val yygone = ref yygone0	(* position in file of beginning of buffer *)
	val yydone = ref false		(* eof found yet? *)
	val yybegin = ref 1		(*Current 'start state' for lexer *)

	val YYBEGIN = fn (Internal.StartStates.STARTSTATE x) =>
		 yybegin := x

fun lex () : Internal.result =
let fun continue() = lex() in
  let fun scan (s,AcceptingLeaves : Internal.yyfinstate list list,l,i0) =
	let fun action (i,nil) = raise LexError
	| action (i,nil::l) = action (i-1,l)
	| action (i,(node::acts)::l) =
		case node of
		    Internal.N yyk => 
			(let val yytext = substring(!yyb,i0,i-i0)
			     val yypos = i0+ !yygone
			open UserDeclarations Internal.StartStates
 in (yybufpos := i; case yyk of 

			(* Application actions *)

  100 => (Tokens.EQSIGN(!pos,!pos))
| 102 => (Tokens.GREATER(!pos,!pos))
| 105 => (Tokens.GREATEREQ(!pos, !pos))
| 107 => (Tokens.LESS(!pos,!pos))
| 110 => (Tokens.LESSEQ(!pos, !pos))
| 112 => (Tokens.NEG(!pos,!pos))
| 114 => (Tokens.CARET(!pos,!pos))
| 116 => (YYBEGIN STRING; charlist := [""]; continue ())
| 121 => (YYBEGIN INITIAL;
                  error ("unterminated string constant",!pos,!pos);
                  pos := (!pos)+1; (* charlist := "";*)
                  continue() )
| 123 => (YYBEGIN INITIAL;
               Tokens.STRING (makeString (), !pos,!pos))
| 126 => (addString "\""; continue())
| 128 => (addString (yytext); continue ())
| 13 => (recognizeDataCon (yytext,!pos,!pos))
| 130 => (error ("bad character "^yytext,!pos,!pos);
                 continue())
| 19 => (K.keyword (yytext,!pos,!pos))
| 24 => (Tokens.LBRACE(!pos,!pos))
| 29 => (Tokens.RBRACE(!pos,!pos))
| 33 => (Tokens.INT(valOf (Int.fromString (yytext)),!pos,!pos))
| 39 => (Tokens.REAL(valOf (Real.fromString (yytext)),!pos,!pos))
| 4 => (pos := (!pos) + 1; continue())
| 42 => (YYBEGIN CHAR; charlist:=[""];continue ())
| 47 => (YYBEGIN INITIAL;
                error ("unterminated character constant",!pos,!pos);
                pos := (!pos)+1;
                continue ())
| 49 => (YYBEGIN INITIAL;
             (*if length(!charlist)=2 then*)
             let val c = makeString()
             in
               if String.size(c) = 1 then
                   Tokens.CHAR (valOf (Char.fromString (c)),!pos,!pos)
               else error("invalid character", !pos, !pos)
             end)
| 52 => (addString "\""; continue() )
| 54 => (addString (yytext); continue ())
| 56 => (Tokens.HASH(!pos,!pos))
| 58 => (Tokens.SEMICOLON(!pos,!pos))
| 60 => (Tokens.UNDERSCORE(!pos,!pos))
| 62 => (Tokens.COMMA(!pos,!pos))
| 65 => (Tokens.ASSGN(!pos,!pos))
| 67 => (Tokens.COLON(!pos,!pos))
| 69 => (Tokens.BANG (!pos,!pos))
| 7 => (continue())
| 72 => (YYBEGIN COMMENT; commentNesting := 0; continue ())
| 75 => (if (!commentNesting)=0
                    then (YYBEGIN INITIAL;
                          continue ())
                  else (commentNesting := (!commentNesting)-1;
                        continue ()))
| 78 => (commentNesting := (!commentNesting)+1;
                  continue ())
| 80 => (continue())
| 82 => (Tokens.LPAREN(!pos,!pos))
| 84 => (Tokens.RPAREN(!pos,!pos))
| 86 => (Tokens.BAR(!pos,!pos))
| 88 => (Tokens.TIMES(!pos,!pos))
| 90 => (Tokens.PLUS(!pos,!pos))
| 93 => (Tokens.ARROW(!pos,!pos))
| 95 => (Tokens.MINUS(!pos,!pos))
| 98 => (Tokens.DARROW(!pos,!pos))
| _ => raise Internal.LexerError

		) end )

	val {fin,trans} = Vector.sub(Internal.tab, s)
	val NewAcceptingLeaves = fin::AcceptingLeaves
	in if l = !yybl then
	     if trans = #trans(Vector.sub(Internal.tab,0))
	       then action(l,NewAcceptingLeaves
) else	    let val newchars= if !yydone then "" else yyinput 1024
	    in if (size newchars)=0
		  then (yydone := true;
		        if (l=i0) then UserDeclarations.eof ()
		                  else action(l,NewAcceptingLeaves))
		  else (if i0=l then yyb := newchars
		     else yyb := substring(!yyb,i0,l-i0)^newchars;
		     yygone := !yygone+i0;
		     yybl := size (!yyb);
		     scan (s,AcceptingLeaves,l-i0,0))
	    end
	  else let val NewChar = Char.ord(String.sub(!yyb,l))
		val NewState = if NewChar<128 then Char.ord(String.sub(trans,NewChar)) else Char.ord(String.sub(trans,128))
		in if NewState=0 then action(l,NewAcceptingLeaves)
		else scan(NewState,NewAcceptingLeaves,l+1,i0)
	end
	end
(*
	val start= if substring(!yyb,!yybufpos-1,1)="\n"
then !yybegin+1 else !yybegin
*)
	in scan(!yybegin (* start *),nil,!yybufpos,!yybufpos)
    end
end
  in lex
  end
end
