structure Value = struct

  (* representations of values as they would occur in the machine *)
  datatype value =  
    Int_v of int     (* an int or a char *)
  | Real_v of real   (* a real *)
  | Ptr_v of int     (* a pointer -- some index into the heap *)
  | Tag_v of int     (* a tag for the beginning of an object -- the int 
		      * is the number of words in the object (not including
		      * the tag.) *)
  | Forward_v of int (* a forwarding pointer -- used only by the gc *)
  | Code_v of Lambda.lexp (* "code" -- in practice, this would be the address
		           * of the machine code for a function *)

  (* convert a machine value to a string for printing *)
  fun value2string(v:value):string = 
      case v of
	  Int_v(i) => "I("^(Int.toString i)^")"
	| Real_v(r) => "R("^(Real.toString r)^")"
	| Ptr_v(p) => "P("^(Int.toString p)^")"
	| Tag_v(i) => "T("^(Int.toString i)^")"
	| Forward_v(i) => "F("^(Int.toString i)^")"
	| Code_v(e) => "C("^(Lambda.ppLexp e)^")"

  (* print a machine value *)
  fun print_value(v:value):unit = print(value2string(v))
 end