structure Stack = struct
  (* The operand stack -- used to save intermediate values.  We must
   * be careful to have everything on the stack before doing a gc. *)
  val max_stack_size : int = 1000;
  val stack : Value.value array =
      Array.array(max_stack_size, Value.Int_v(0));
  (* Register which points to the next available word on the operand stack *)
  val stackptr : int ref = ref 0;

  (* Push a value onto the operand stack *)
  fun push(v:Value.value):unit =
      (Array.update(stack,!stackptr,v); stackptr := !stackptr + 1)

  (* Pop a value off of the operand stack *)
  fun pop():Value.value =
      let val s = !stackptr - 1
          val r = Array.sub(stack,s)
      in
      stackptr := s; r
      end

  (* Reset the stack *)
  fun reset():unit =
      (stackptr := 0; Array.modify (fn _ => Value.Int_v 0) stack)

  (* Print out the current operand stack *)
  fun print_stack():unit =
      let fun loop(i:int) =
      if i < (!stackptr) then
          (print (Int.toString i); print ":";
           Value.print_value (Array.sub(stack,i));
           print "\n";
           loop (i+1))
      else ()
      in
      print "stack dump: stackptr="; print (Int.toString(!stackptr));
      print "\n------------------------------------\n";
      loop(0);
      print "-------------------------------------\n"
      end
end