signature PROBLEM1 = sig
  type bignum = { neg: bool, coeffs: int list }
  val toString : bignum -> string
end

signature PROBLEM2 = sig
  type bignum = { neg: bool, coeffs: int list }
  val equal : bignum * bignum -> bool
  val less : bignum * bignum -> bool
  val compare : bignum * bignum -> order
  val repOk  : bignum -> bool
end

signature PROBLEM3 = sig
  type bignum = { neg: bool, coeffs: int list }
  val plus : bignum * bignum -> bignum
  val negate : bignum -> bignum
  val times : bignum * bignum -> bignum
end

signature PROBLEM4 = sig
  type bignum = RSABigNums.bignum
  type key = {modulus: bignum, exponent: bignum}

  val decryptList : bignum list * key -> bignum list
end

signature PROBLEM5 = sig
  type bignum = RSABigNums.bignum

  val smallestDivisor : bignum -> bignum
end

signature PROBLEM6 = sig
  type bignum = RSABigNums.bignum
  type key = {modulus: bignum, exponent: bignum}

  val crack : key -> key
end

signature PROBLEM7 = sig
  type bignum = RSABigNums.bignum
  type key = {modulus: bignum, exponent: bignum}
  type signed_message = {msg: bignum list, sign: bignum}

  val encryptAndSign : string * key * key -> signed_message
  val authenticateAndDecrypt : signed_message * key * key -> string
end

signature OPTIONALPROBLEM = sig
  type bignum = { neg: bool, coeffs: int list }

  val divmod : bignum * bignum -> bignum * bignum
end
