signature BIGNUMS = sig

  (* A bignum represents an integer. It may be arbitrarily large.
   * Most of its operations are self-explanatory. *)
  type bignum

  (* conversion to and from string.
   * fromString called on a non-numeric strings returns NONE *)
  val toString : bignum -> string
  val fromString : string -> bignum option


  (* conversion to and from ints.
   * In case of overflow in toInt, returned value is NONE *)
  val toInt : bignum -> int option
  val fromInt : int -> bignum


  (* equal, less, compare are the usual integer comparisons *)
  val equal : bignum * bignum -> bool
  val less : bignum * bignum -> bool
  val compare : bignum * bignum -> order

  (* negate(x) is -x *)
  val negate : bignum -> bignum

  (* plus, minus, times are the usual operations on integers. *)
  val plus : bignum * bignum -> bignum
  val minus : bignum * bignum -> bignum
  val times : bignum * bignum -> bignum

  (* divmod(i,j) is a pair (q,r) where q is
   * the truncated quotient of the division of i by j
   * (that is, floor(i/j)), and r is the remainder,
   * satisfying the equation divide(i,j) * j + modulo(i,j) = i.
   * Rounding is towards negative infinity, not zero, and thus
   * (i mod j) has the same sign as j.
   * Checks: j != 0.
   *
   * NOTE: May not be implemented; if so, always raises Fail. *)
  val divmod : bignum * bignum -> bignum * bignum
end
