structure Tests = struct

  val b = RSA.B.fromInt

  val key_pair1 = {public= {modulus= b 979739,
                            exponent= b 909703},
                   private={modulus= b 979739,
                            exponent= b 692407}}
  val key_pair2 = {public= {modulus= b 551687,
                            exponent= b 18499},
                   private= {modulus= b 551687,
                             exponent= b 94699}}

  val public_key1 = #public (key_pair1)
  val private_key1 = #private (key_pair1)

  val public_key2 = #public (key_pair2)
  val private_key2 = #private (key_pair2)

  val Abhishek : RSA.key = {exponent=b 109459211, modulus=b 825898757}
  val Emmanuel : RSA.key = {exponent=b 123531, modulus=b 130813}
  val Frances : RSA.key = {exponent=b 591944449, modulus=b 638511527}
  val Gregory : RSA.key = {exponent=b 130623389, modulus=b 823906949}
  val Haakon : RSA.key = {exponent=b 279225619, modulus=b 379437983}
  val Hubert : RSA.key = {exponent=b 8586661, modulus=b 219066443}
  val Jackie : RSA.key = {exponent=b 43434263, modulus=b 578825029}
  val Jeff : RSA.key = {exponent=b 456300199, modulus=b 599755777}
  val Jeffery : RSA.key = {exponent=b 562210217, modulus=b 836286257}
  val Justin : RSA.key = {exponent=b 420931115, modulus=b 511294727}
  val Kori : RSA.key = {exponent=b 490545623, modulus=b 512989889}
  val Ramin : RSA.key = {exponent=b 190864249, modulus=b 342157441}
  val Saikat : RSA.key = {exponent=b 362713627, modulus=b 511209007}
  val Sergey : RSA.key = {exponent=b 5074291, modulus=b 10385701}
  val Sigmund : RSA.key = {exponent=b 3500239, modulus=b 8752021}
  val Tibor: RSA.key = {exponent=b 83797229, modulus=b 505755781}
  val Tim : RSA.key = {exponent=b 469835901, modulus=b 482230207}
  val Walter : RSA.key = {exponent=b 360455983, modulus=b 490884203}

  (* secret message *)
  local
    val secret = map b [234530, 9903374, 10013379, 9859646, 2185349,
                        1848451, 7236019, 9725346, 7788472, 10260625,
                        6148577, 3928405, 5069698, 4780995, 6341853,
                        4190801, 8715470, 1586233, 7480958, 2177778,
                        7223457, 7574410, 5556674, 4874006, 3810355,
                        2594112, 7610733, 4201360, 1889948, 3618656,
                        4293665, 349034, 10097095, 851782, 7602837,
                        9275502, 3297228, 1889889, 448168, 820245,
                        5840102, 7049268, 6881887, 1628378, 1649110,
                        5350774, 5270375, 2295383, 7207070, 5106162,
                        2791082, 1268046, 10366939, 3208056, 7972560,
                        7884800, 5049150, 8403521, 1468834, 1681814,
                        9764883, 9795549, 1269528, 1005821, 1989138,
                        4158830, 2893422, 7089171, 8306408, 3516257,
                        4438742, 2672452, 7032198, 1505888, 9974117,
                        1199958, 5395001, 5877072, 6520445, 7836701,
                        1987073, 3224362, 2472525, 8318379, 4911342,
                        2809175, 8880626, 1971139, 2128578, 5812374,
                        6436165, 4089017, 4931228, 8335033, 9206630,
                        9439599, 8418680, 679688, 5794383, 321342,
                        8279841, 8134268, 6278010, 1287589, 926101,
                        5917905, 10129614, 139911, 7816442, 7329764,
                        9554547, 4052032, 3251497, 2919279, 1392307,
                        7736051, 3184319, 9671129, 4956720, 989207,
                        6760179, 5667200, 3093580, 3052281, 9144886,
                        8999551, 2075811, 3934745, 715311, 8848304,
                        1010690, 1224421, 7545285, 9172029, 9345857,
                        5274380, 6773902, 2623056, 1125893, 2531399,
                        5700795, 43051, 7881952, 8121800, 6867842,
                        4902036, 8220351, 978337, 3239511, 4963574,
                        818394, 1490404, 2237265, 5250750, 9700321,
                        8775122, 2010932, 1712049, 7345105, 3234935,
                        7124214, 6451545, 5515829, 5090287, 2695066,
                        52909, 10074804, 8262576, 6032371, 4489265,
                        4259550, 4634190, 3825709, 8744164, 8415334,
                        6324811, 713096, 8997595, 2262990, 2074573,
                        43494, 2548084, 4317354, 7743953, 3595140,
                        1519760, 566500, 9532189, 581828, 7523796,
                        5054335, 3524227, 8013414, 3282201, 8815965,
                        5288942, 42992, 6830332, 2342380, 4943565,
                        10166509, 9478783, 5100016, 6498355, 8077738,
                        491022, 3124265, 4284983, 7089890, 4709359,
                        8092664, 1827424, 8460037, 84494, 1219152,
                        7965516, 9654468, 5711152, 6974825, 666156,
                        4175182, 9298762, 9286742, 3774145, 338749,
                        3727335, 8849819, 1410038, 3757060, 2256942,
                        4561063, 6875905, 7944832, 4911003, 5359071,
                        8411299, 198769, 9897965, 4811009, 6621085,
                        6742986, 1188847, 3100340, 654245, 7009487,
                        6759672, 3638074, 5623411, 5992900, 2876553,
                        10184925, 6210028, 5983494, 4140248, 6002201,
                        7608192, 1357361, 7943163, 6183298, 5447103,
                        1669881, 10198100, 2765850, 6842690, 6275629,
                        3590799, 983941, 3399132, 435169, 7609322,
                        5802727, 4992286, 1567868, 1387011, 5939721,
                        5068810, 4936734, 1442081, 4123483, 193379,
                        9860483, 1555775, 3063045, 8138794, 6987498,
                        8478556, 2061489, 2070764, 4254959, 5111276,
                        7232048, 7301310, 9155840, 3774942, 6407997,
                        1998031, 6591334, 7966774, 6025008, 4792201,
                        3798133, 3839923, 3147732, 9847883, 6048848,
                        2160617, 7005248, 4109683, 8723970, 2399298,
                        1947804, 4299741, 4167397, 7221606, 6534800,
                        10044458, 9601397, 6104101, 4425160, 3590862,
                        3480616, 3394303, 1140129, 9350027, 1420882,
                        7504546, 6642241, 10262908, 7537219, 8859093,
                        10222060, 820036, 3677290, 9896418, 8409935,
                        1282544, 8360709, 6068751, 7106358, 914440]
    val secretSignature = b 1032528
  in
    val secretMessage : RSA.signed_message = {msg=secret,sign=secretSignature}
  end

end