structure Problem7 :> PROBLEM7 = struct
  open RSASupport1
  open RSASupport2

  fun encryptAndSign (msg:string, sk: key, mk:key):signed_message =
    let
      val msg' = encrypt (msg,mk)
      val hash = compress msg'
      val sign = transform (hash,sk)
    in
      {msg = msg', sign = sign}
    end

  fun authenticateAndDecrypt ({msg,sign}:signed_message,sk:key,mk:key):string =
    let
      val hash = compress msg
      val sign_hash = transform (sign,sk)
    in
      if B.equal (hash,sign_hash) then
        decrypt (msg,mk)
      else raise Fail "Authentication failed!"
    end
end