structure Problem2 :> PROBLEM2 = struct
  type bignum = { neg: bool, coeffs: int list }
  val base = BigNumsSupport1.base

 (* Representation invariant:
   * Every coefficient is between 0 and base-1
   * and the last coefficient is nonzero
   * or if the number is zero then neg = false, coeffs = [] *)
  fun repOk ({neg, coeffs} : bignum) : bool =
    let
      fun withinRange(x: int) : bool = (x >= 0 andalso x < base)
    in
      case coeffs of
        [] => not neg
      | _ => List.all withinRange coeffs andalso List.last coeffs <> 0
          andalso not (List.all (fn x => x = 0) coeffs)
    end
 

  fun equal(a: bignum, b: bignum): bool =
    raise Fail("equal not implemented")

  fun less(a: bignum, b: bignum): bool =
    raise Fail("less not implemented")

  fun compare(a: bignum, b: bignum): order =
    case (equal(a,b), less(a,b)) of
      (true, _) => EQUAL
    | (false, true) => LESS
    | (false, false) => GREATER
end
