structure Error :> sig

  exception Error
  val parse   : string -> 'a
  val runtime : string -> 'a
  val static  : string -> 'a
  val fail    : string -> 'a

end = struct

  exception Error

  fun error (flag:string) (s:string):'a =
    (print (flag ^ s); print ".\n"; raise Error)

  (* generate a parse error *)
  fun parse   (s:string):'a  = error "PARSE ERROR: " s

  (* generate a runtime error *)
  fun runtime (s:string):'a  = error "RUNTIME ERROR: " s

  (* generate a static (type checking) error *)
  fun static  (s:string):'a  = error "STATIC TYPE-CHECKING ERROR: " s

  (* generate an 'exception thrown' error *)
  fun fail    (s: string):'a = error "MINI-SML EXCEPTION: " s

end
