#!/bin/bash
# DO NOT EDIT THIS FILE

environment=good

OPAM_LOCATION="$(command -v opam)"
if [[ "$OPAM_LOCATION" == "" ]]; then
  echo "OPAM is NOT available.  This is bad."
  environment=bad
else
  echo "OPAM is available.  Good."
fi

COQC_VERSION="$(coqc --version 2>&1)"
if [[ "$COQC_VERSION" =~ "8.7.1" ]]; then
  echo "Coq compiler version 8.7.1 is active.  Good."
else
  echo "Coq compiler version 8.7.1 is NOT active.  This is bad."
  environment=bad
fi

if [[ "$environment" == good ]]; then
  cat <<EOF
===========================================================
Your Coq environment looks good to me.  Congratulations!
===========================================================
EOF
else
  cat <<EOF
===========================================================
WARNING

Your Coq environment looks broken to me.  The code that
you submit might not compile on the grader's machine,
leading to heavy penalties.  Please fix your Coq
environment. Check the error messages above carefully to
determine what is wrong with your environment.  See a
consultant for help if you cannot determine what is wrong.
===========================================================
EOF
fi
