open Big_int

module type FIELD = sig
  (** [t] is the type of the element in the field. *)
  type t

  (** [zero] is the additive identity *)
  val zero : t

  (** [one] is the multiplicative identity *)
  val one : t

  (** [add a b] returns [a + b] *)
  val add : t -> t -> t

  (** [mul a b] returns [a * b] *)
  val mul : t -> t -> t

  (** [neg x] returns [-x], the additive inverse of x *)
  val neg : t -> t

  (** [inv x] returns [1/x], the multiplicative inverse of x
   *  precondition: x is not equal to 0 *)
  val inv : t -> t

  (** [num_of_big_int b] returns the field representation of Big Int [b] *)
  val num_of_big_int : big_int -> t

  (** [num_of_int i] returns the field representation of int [i] *)
  val num_of_int : int -> t
end

module type OrderedField = sig
  include FIELD

  (** [cmp a b] returns an integer i, such that:
   *  if a is greater than b, then i>0
   *  if a is equal to b,     then i=0
   *  if a is less than b,    then i < 0
   *)
  val cmp : t -> t -> int
end

module Floats : (OrderedField with type t = float)