open Big_int

module type FIELD = sig
  type t

  val zero : t
  val one : t

  val add : t -> t -> t
  val mul : t -> t -> t
  val neg : t -> t
  val inv : t -> t

  val num_of_big_int : big_int -> t
  val num_of_int : int -> t
end

module type OrderedField = sig
  include FIELD

  val cmp : t -> t -> int
end

module Floats : (OrderedField with type t = float) = struct
  type t = float
  let zero = 0.
  let one = 1.
  let add = (+.)
  let mul = ( *. )
  let neg = (~-.)
  let inv x = 1. /. x
  let cmp = compare
  let num_of_big_int = float_of_big_int
  let num_of_int = float
end
