module type N = sig
  (** [t] represents a natural number. *)
  type t

  (** [zero] returns the [t] representing 0. *)
  val zero : t

  (** [succ x] returns the successor to [x] *)
  val succ : t -> t

  (** [eq a b] returns [a = b] *)
  val eq : t -> t -> bool

  (** [add a b] returns [a + b]. *)
  val add : t -> t -> t

  (** [mul a b] returns [a * b]. *)
  val mul : t -> t -> t

  (** [lt a b] returns [a < b] *)
  val lt : t -> t -> bool

  (** [make x] returns [Some x] if x>=0, [None] otherwise.*)
  val make : int -> t option

  (** [to_int x] returns the integer representation of x
   *  it is undefined if x cannot be represented as an integer *)
  val to_int : t -> int
end

module IntNat : N with type t = int
module BigIntNat : N with type t = Big_int.big_int
