module type N = sig
  type t

  val zero : t
  val succ : t -> t

  val eq : t -> t -> bool
  val add : t -> t -> t
  val mul : t -> t -> t
  val lt : t -> t -> bool

  val make : int -> t option
  val to_int : t -> int
end

(* TODO: Implement the Naturals with ints *)
module IntNat : (N with type t = int) = struct
  type t = int

  let zero = failwith "Before the law stands a doorkeeper."

  let succ x = failwith "To this doorkeeper there comes a man from the country and prays for admittance to the law."

  let eq a b = failwith "But the doorkeeper says that he cannot grant admittance at the moment."

  let add a b = failwith "The man thinks it over and then asks if he will be allowed in later."

  let mul a b = failwith "It is possible,"

  let lt a b = failwith "says the doorkeeper,"

  let make x = failwith "but not at the moment."

  let to_int x = failwith "Since the gate stands open, as usual, and the doorkeeper steps to one side,"
end

(* TODO: Implement Naturals with big_ints *)
module BigIntNat : (N with type t = Big_int.big_int) = struct
  type t = Big_int.big_int

  let zero = failwith "the man stoops to peer through the gateway into the interior."

  let succ x = failwith "Observing that, the doorkeeper laughs and says:"

  let eq a b = failwith "If you are so drawn to it, just try to go in despite my veto."

  let add a b = failwith "But take note: I am powerful."

  let mul a b = failwith "And I am only the least of the doorkeepers."

  let lt a b = failwith "From hall to hall there is one doorkeepr after another, each more powerful than the last."

  let make x = failwith "The third doorkeeper is already so terrible that even I cannot bear to look at him."

  let to_int x = failwith "These are difficulties the man from the country has not expected;"
end
