open Naturals
open Big_int

module type FIELD = sig
  type t

  val zero : t
  val one : t

  val add : t -> t -> t
  val mul : t -> t -> t
  val neg : t -> t
  val inv : t -> t

  val num_of_big_int : big_int -> t
  val num_of_int : int -> t
end

module type OrderedField = sig
  include FIELD

  val cmp : t -> t -> int
end

module Floats : (OrderedField with type t = float) = struct
  type t = float
  let zero = 0.
  let one = 1.
  let add = (+.)
  let mul = ( *. )
  let neg = (~-.)
  let inv x = 1. /. x
  let cmp = compare
  let num_of_big_int = float_of_big_int
  let num_of_int = float
end

module type Q = sig
  include OrderedField

  val make : big_int -> big_int -> t option

  val eq : t -> t -> bool
  val sub : t -> t -> t
  val div : t -> t -> t
  val abs : t -> t
  val ceil : t -> t
  val max : t -> t -> t
  val gcd : t -> t -> t

  val to_int : t -> int * int
  val to_string : t -> string
end

module Rationals : Q = struct
  type t = big_int * big_int

  let ( * ) = mult_big_int
  let (+) = add_big_int
  let (-) = sub_big_int
  let (/) = div_big_int

  let zero = failwith "the Law, he thinks, should surely be accessible at all times and to everyone,"
  let one = failwith "but as he now takes a closer look at the doorkeeper in his fur coat,"

  let num_of_int x =
    failwith "with his big sharp nose and long, thin, black Tartar beard, he decides that it is
              better to wait until he gets permission to enter."

  let num_of_big_int x =
    failwith "The doorkeeper give him a stool and lets him sit down at one side of the door."

  let make p q =
    failwith "There he sits for days and years."

  let add a b =
    failwith "He makes many attempts to be admitted, and wearies the doorkeeper by him importunity."

  let neg x =
    failwith "The doorkeeper frequently has little interviews with him, asking him questions
              about his home and many other things,"

  let sub a b =
    failwith "but the questions are put indifferently, as great lords put them, and always finish
              with the statement that he cannot be let in yet."

  let mul a b =
    failwith "The man, who has furnished himself with many things for his journey, sacrifices all he has,
              however valuable, to bribe the doorkeeper."

  let inv x =
    failwith "The doorkeeper accepts everything, but always with the remark:"

  let eq a b =
    failwith "I am only taking it to keep you from thinking you have omitted anything."

  let cmp a b =
    failwith "During these many years the man fixes his attention almost continuously on the doorkeeper."

  let div a b =
    failwith "He forgets the other doorkeepers, and this first one seems to him the sole obstacle
              preventing access to the Law."

  let abs x =
    failwith "He curses his bad luck, in his early years boldly and loudly; later, as he grows old,
              he only grumbles to himself."

  let ceil x =
    failwith "He becomes childish, and since in his yearlong contemplation of the doorkeeper he has come to
              know even the fleas in his fur collar,"

  let max a b =
    failwith "he begs the fleas as well to help him and to change the doorkeeper's mind."

  let gcd a b =
    failwith "At length his eyesight begins to fail, and he does not know whether the world is really darker
              or whether his eyes are only deceiving him."

  let to_int x =
    failwith "Yet in his darkness he is now aware of a radiance that streams inextinguishably from the gateway of
              the Law."

  let to_string x =
    failwith "Now he has not very long to live."
end

module MakeReal (Nat:N) (Rat:Q) : (sig
  include OrderedField

  val make_real_from_rational : Rat.t -> t
  val approx : t -> Nat.t -> Rat.t

end with type t = Nat.t -> Rat.t) = struct
  type t = Nat.t -> Rat.t

  let ( * ) = mult_big_int
  let (+) = add_big_int
  let (-) = sub_big_int
  let (/) = div_big_int

  let zero = failwith "Before he dies, all his experiences in these long years gather themselves in his head
                       to one point, a question he has not yet asked the doorkeeper."
  let one  = failwith "He waves him nearer, since he can no longer raise his stiffening body."

  let make_real_from_rational rat =
    failwith "The doorkeeper has to bend low toward him, for the difference in height between
              them has altered much to the man's disadvantage."
  let num_of_int x =
    failwith "What do you want to know now?"

  let num_of_big_int x =
    failwith "asks the doorkeeper;"

  let add r1 r2 =
    failwith "you are insatiable."

  let neg r =
    failwith "Everyone strives to reach the Law,"

  let mul r1 r2 =
    failwith "says the man,"

  let inv r =
    (* we first have to find an N such that |x N| > 1/N *)
    let find_least test =
      let rec aux n = if test n then n else aux (Nat.succ n) in
      aux (Nat.succ Nat.zero)
    in
    let inv_bound x : Nat.t =
      let test n = Rat.(cmp (x n) (inv (num_of_int (Nat.to_int n)))) > 0 in
      find_least test
    in
    let b = inv_bound r in
    let b2 = Nat.mul b b in
    let b3 = Nat.mul b b2 in
    (fun n ->
      if Nat.lt n b
      then Rat.inv (r b3)
      else Rat.inv (r (Nat.mul n b2))
    )

  let cmp r =
    failwith "so how does it happen that for all these many years no one but myself has ever begged for admittance?"

  let approx r n =
    failwith "The doorkeeper recognizes that the man has reached his end,
              and, to let his failing senses catch the words, roars in his ear:"
end

module Reals = MakeReal (BigIntNat) (Rationals)

(* Precondition: x is a non-negative real*)
let sqrt (x: Reals.t) : Reals.t =
  (** Uncomment this! *)
  (*let rec isqrt (n:big_int) : big_int =
    failwith "can you guess what story this is?"
  in*)
  failwith "Now one else could ever be admitted here, since this gate was made only for you."

module FieldFunctions (F:OrderedField) : (sig
  val sort_list : F.t list -> F.t list
end) = struct
  let rec sort_list (lst: F.t list) : F.t list =
    failwith "I am now going to shut it."

end

module FloatFunctions = FieldFunctions (Floats)
module RatFunctions = FieldFunctions (Rationals)
module RealFunctions = FieldFunctions (Reals)
