open Big_int

type cmp =
  | Less
  | Greater
  | Equal 

module type Q = sig
  type t
  val zero : t (** the rational number 0 *)
  val one : t  (** the rational number 1 *)

  (** [make p q] returns [Some x] where [x] represents the
      rational [p/q] if [q <> 0] and [None] otherwise. *)
  val make : int -> int -> t option

  (** make_big behaves exactly as make, except it takes arbitrary
      big integer as inputs. *)
  val make_big: Big_int.big_int -> Big_int.big_int -> t option 

  (** [add a b] returns [a + b]. *)
  val add : t -> t -> t

  (** [inv x] returns [1/x]. *)
  val inv : t -> t

  (** [neg x] returns [-x]. *)
  val neg : t -> t

  (** [mul a b] returns [a * b]. *)
  val mul : t -> t -> t
  
  (** [eq a b] returns [a = b]. *)
  val eq : t -> t -> bool

  (** [cmp a b] returns [Less] if [a < b], [Greater] if
      [a > b], and [Equal] if [a = b]. *)
  val cmp : t -> t -> cmp

  (** [div a b] returns [a / b]. *)
  val div : t -> t -> t
  
  (** [gcd a b] returns the gcd of [a] and [b]. *)
  val gcd : t -> t -> t
  
  (** [abs x] returns x if x is non-negetive and [neg x] otherwise. *)
  val abs : t -> t 

  (** [ceil x] returns the smallest integer that is strictly greater than x *)
  val ceil : t -> t  

  (** [max x y] returns x if x>=y , y otherwise. *)
  val max : t -> t -> t

  (** [to_int x] returns [p] and [q] such that [p/q = x]. *)
  val to_int : t -> Big_int.big_int * Big_int.big_int

  (** [to_string x] returns the string representation of x as [num/denom]*)
  val to_string: t-> string 
end

module Rational : Q 
