open Naturals
open Rationals
open Big_int

module type FIELD = sig
	type t 

	val zero : t  (** the additive unit of the field *)
	val one : t   (** the multiplicative unit of the field *)

    (** [add x y] performs addition on inputs and return the result*)
	val add : t -> t -> t

    (** [multiply x y] performs multiplication on inputs and return the result*)
	val multiply : t -> t -> t

	(*[negate x] satisfies [add (negate x) x] = zero *)
	val negate : t -> t

	(*[inverse x] satisfies [multiply (inverse x) x] = one
      [pre-condition] x != zero*)
	val inverse : t -> t
end

(*Exercises 2 ~ 6 *)
module MakeReal : functor (Nat:N) -> functor (Rat:Q) -> sig 
    include FIELD

    (** [make_real_from_rational x] returns the 
        representation of x as a real number *)
    val make_real_from_rational : Rat.t -> t 

    (** [pow x n] = [x * x * ... * x], n times. 
        [pow x 0] = one *)
    val pow : t -> Nat.t -> t 

    (** [approx x n] returns a rational q such that 
        |x-q|< 1/n *)
    val approx : t -> Nat.t -> Rat.t

(** We define reals as a regular sequence of rationals*)
end with type t = Nat.t -> Rat.t 

module Reals : sig 
    include FIELD

    (** [make_real_from_rational x] returns the 
        representation of x as a real number *)
    val make_real_from_rational : Rational.t -> t 

    (** [pow x n] = [x * x * ... * x], n times. 
        [pow x 0] = one *)
    val pow : t -> IntNat.t -> t 

    (** [approx x n] returns a rational q such that 
        |x-q|< 1/n *)
    val approx : t -> IntNat.t -> Rational.t
    
(** We define reals as a regular sequence of rationals*)
end with type t = IntNat.t -> Rational.t 

(*Exercises 7 ~ 9 *)

(** [ [sqrt x] * [sqrt x] = x ] for arbitrary precision. 
    [precondition]: x >= 0 *)
val sqrt : Reals.t -> Reals.t

(** [cos x] = cos(x) *)
val cos : Reals.t -> Reals.t

(** [exp x] = e^x *)
val exp : Reals.t -> Reals.t

