open Naturals
open Rationals
open Big_int

module type FIELD = sig
	type t 

	val zero : t  (** the additive unit of the field *)
	val one : t   (** the multiplicative unit of the field *)

    (** [add x y] performs addition on inputs and return the result*)
	val add : t -> t -> t

    (** [multiply x y] performs multiplication on inputs and return the result*)
	val multiply : t -> t -> t

	(*[negate x] satisfies [add (negate x) x] = zero *)
	val negate : t -> t

	(*[inverse x] satisfies [multiply (inverse x) x] = one
      [pre-condition] x != zero*)
	val inverse : t -> t
end

module MakeReal (Nat:N) (Rat:Q): sig 
    include FIELD

    (** [make_real_from_rational x] returns the 
        representation of x as a real number *)
    val make_real_from_rational : Rat.t -> t 

    (** [pow x n] = [x * x * ... * x], n times. 
        [pow x 0] = one *)
    val pow : t -> Nat.t -> t 

    (** [approx x n] returns a rational q such that 
        |x-q|< 1/n *)
    val approx : t -> Nat.t -> Rat.t

(** We define reals as a regular sequence of rationals*)
end with type t = Nat.t -> Rat.t  = 
struct
	type t = Nat.t -> Rat.t

    let zero = fun _ -> failwith "unimplemented" (** [YOU should change this!] *)
    let one = fun _ -> failwith "unimplemented" (** [YOU should change this!] *)

    let add r1 r2 = 
    	failwith "unimplemented"
    
    let multiply r1 r2 =
    	failwith "unimplemented"

    let negate r = 
    	failwith "unimplemented"

    let inverse r = 
    	failwith "unimplemented"

    let make_real_from_rational rat =
    	failwith "unimplemented"

    let pow r n= 
    	failwith "unimplemented"

	let approx r n = 
        failwith "unimplemented"
end 

module Reals = MakeReal (IntNat) (Rational)

(*[pre] x is a non-negative real*)
let sqrt (x: Reals.t) : Reals.t = 
    (** Uncomment this! *)
(*     let rec isqrt (n:big_int) : big_int = 
        failwith "unimplemented"
    in  *)
    failwith "unimplemented"

let cos (x:Reals.t):Reals.t = 
    (** cal_yn that calculates the partial sum for value x up to nth term,
        tail-recursively. *)
    (** [Note] You don't have to implement cos like this. 
        Feel free to delete these helpers.*)
(*     let cal_yn x_n n = 
        let rec helper sum_acc sign_acc x_term_acc fact_acc k = 
            failwith "unimplemented"
        in 
    failwith "unimplemented"
    in  *)
    failwith "unimplemented"

let exp (x:Reals.t):Reals.t = 
    failwith "unimplemented"
    
