module type N = sig
  (** [t] represents a natural number. *)
  type t = int 

  (** [zero] returns the [t] representing 0. *)
  val zero : t

  (** [eq a b] returns [a = b] *)
  val eq : t -> t -> bool

  (** [add a b] returns [a + b]. *)
  val (+) : t -> t -> t

  (** [mul a b] returns [a * b]. *)
  val ( * ) : t -> t -> t  

  (** [make x] returns [Some x] if x>=0, [None] otherwise.*)
  val make : int -> t option
end

module IntNat : N with type t = int