
module type N = sig
  (** [t] represents a natural number. *)
  type t = int 

  (** [zero] returns the [t] representing 0. *)
  val zero : t

  (** [eq a b] returns [a = b] *)
  val eq : t -> t -> bool

  (** [add a b] returns [a + b]. *)
  val (+) : t -> t -> t

  (** [mul a b] returns [a * b]. *)
  val ( * ) : t -> t -> t  

  (** [make x] returns [Some x] if x>=0, [None] otherwise.*)
  val make : int -> t option
end


module IntNat : N with type t = int = struct
  type t = int

  let zero = 0

  let succ x = x + 1

  let eq x y = x = y

  let (+)  = (+)

  let ( * ) = ( * )
  
  let make x = if x>=0 then Some x else None
end