(* mymap_client.ml *)

(* How to demonstrate this code:
 *  1.  cs3110 compile mymap_client.ml
 *  2.  cs3110 run mymap_client.ml
 * OR
 *  1.  cs3110 compile mymap_client.ml
 *  2.  utop -I _build
 *  3.    #load "mymap.d.cmo";;
 *  4.    #use "mymap_client.ml";;
 *)

module StringNoCase = struct
  type t = string
  let equal s1 s2 = (String.uppercase s1) = (String.uppercase s2)
end

module BoolVal = struct
  type t = bool
end

module StrMap = Mymap.MakeFn (StringNoCase) (BoolVal)

let m = StrMap.add "I like CS 3110" true StrMap.empty
let cs3110ftw = StrMap.find "i LiKe cs 3110" m in
    Printf.printf "cs3110ftw = %B\n" cs3110ftw
let haz_zardoz = try StrMap.find "zardoz" m
		 with StrMap.NotFound -> false in
    Printf.printf "haz_zardoz = %B\n" haz_zardoz


