(* mymap.mli 
 *  We name the module "Mymap" because OCaml's standard
 *  library already has a Map module which we don't want
 *  to clash with. *)

(* Input signature for the functor Map.MakeFn. *)
module type EQUAL =
sig
  type t
  (* returns: whether two values of type t are equal *)
  val equal : t -> t -> bool
end

(* Input signature for the functor Map.MakeFn. *)
module type VALUE = 
sig
  type t
end

(* Output signature of the functor Map.MakeFn. *)
module type S =
sig
  type t
  type key
  type value
	 
  exception NotFound
	      
  (* returns: the empty map *)
  val empty: t
	       
  (* parameters:  a key k and value v, and a map m.
   * returns: a map containing the same bindings as m,
       as well as a binding of k to v. If k was already bound
       in m, its previous binding is shadowed. *)
  val add: key -> value -> t -> t

  (* parameters:  a key k and map m
   * returns: the current binding of k in m.
       Raises NotFound if k is not bound in m *)
  val find: key -> t -> value
end

(* Functor that returns a map implementation given an equality
 * implementation. *)
module MakeFn (Equal : EQUAL) (Value : VALUE)
  : (S with type key = Equal.t 
       with type value = Value.t)

