(* mymap.ml *)

module type EQUAL =
sig
  type t
  val equal : t -> t -> bool
end

module type VALUE = 
sig
  type t
end

module type S =
sig
  type t
  type key
  type value
  exception NotFound
  val empty: t
  val add: key -> value -> t -> t
  val find: key -> t -> value
end

module MakeFn (Equal : EQUAL) (Value : VALUE) 
  : (S with type key = Equal.t
       with type value = Value.t) =
struct
  type key = Equal.t
  type value = Value.t

  (* representation type: association list 
   *  N.B. the OCaml List module has functions for
   *    working with association lists. *)
  type t = (key*value) list

  exception NotFound

  let empty = []
  let add k v m = (k,v)::m
  let rec find k m = match m with
      [] -> raise NotFound
    | (k',v')::m' -> if Equal.equal k k' 
		     then v' else find k m'
end

