(* Returns: lmax xs is the maximum element in the list xs.
 * Checks: xs != []
 *)
let rec lmax (xs : int list) : int =
  match xs with
    [] -> failwith "cannot take max of empty list"
  | [x] -> x
  | x :: t -> max x (lmax t)
