/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;

public class Unit {
    private static Map<UnitType, ImageIcon> unitImages;
    private static Map<UnitType, ImageIcon> unitAttackImages;
    private static Map<UnitType, Integer> maxHealthMap;
    private static int updateStepSize;
    private static int attackDelay;
    public int id;
    public int x;
    public int y;
    public int health;
    public int maxHealth;
    public UnitType type;
    public TeamColor color;
    public ArrayList<Pair<Integer, Integer>> path;
    public int attack;
    private static final int tintFactor = 3;

    static {
        ImageIcon img;
        updateStepSize = 5;
        attackDelay = 20;
        maxHealthMap = new HashMap<UnitType, Integer>();
        unitImages = new HashMap<UnitType, ImageIcon>();
        unitAttackImages = new HashMap<UnitType, ImageIcon>();
        String[] listAttack = new String[]{"", "archer_attack", "elitearcher_attack", "knight_attack", "eliteknight_attack", "swordsman_attack", "eliteswordsman_attack"};
        String[] list = new String[]{"villager_walk", "archer_walk", "elitearcher_walk", "knight_walk", "eliteknight_walk", "swordsman_walk", "eliteswordsman_walk"};
        UnitType[] typeList = new UnitType[]{UnitType.Villager, UnitType.Archer, UnitType.EliteArcher, UnitType.Knight, UnitType.EliteKnight, UnitType.Pikeman, UnitType.ElitePikeman};
        int i = 0;
        while (i < list.length) {
            img = new ImageIcon(String.format("images/%s.gif", list[i]));
            unitImages.put(typeList[i], img);
            ++i;
        }
        i = 1;
        while (i < list.length) {
            img = new ImageIcon(String.format("images/%s.gif", listAttack[i]));
            unitAttackImages.put(typeList[i], img);
            ++i;
        }
    }

    public Unit(int id) {
        this.id = id;
    }

    public Unit(int id, UnitType type, int x, int y, int health, TeamColor color) {
        this.id = id;
        this.type = type;
        this.x = x;
        this.y = y;
        this.color = color;
        this.health = health;
        this.maxHealth = health;
        this.path = new ArrayList();
        this.attack = attackDelay;
    }

    public void updateLocation() {
        if (!this.path.isEmpty()) {
            Pair<Integer, Integer> p = this.path.remove(0);
            this.x = (Integer)p.fst;
            this.y = (Integer)p.snd;
        }
    }

    public void clearMove(int[] position) {
        ArrayList<Pair<Integer, Integer>> new_path = new ArrayList<Pair<Integer, Integer>>();
        boolean found = false;
        for (Pair<Integer, Integer> p : this.path) {
            if (found) {
                this.path = new_path;
                return;
            }
            if (position[0] == (Integer)p.fst && position[1] == (Integer)p.snd) {
                found = true;
                new_path.add(p);
                continue;
            }
            new_path.add(p);
        }
        if (!found) {
            this.path.clear();
        }
    }

    public void addMove(ArrayList<Pair<Integer, Integer>> a) {
        this.path.addAll(a);
    }

    public BufferedImage getTypeImage() {
        ImageIcon imgIcon = null;
        if (this.attack < attackDelay) {
            ++this.attack;
            imgIcon = unitAttackImages.get((Object)this.type);
        } else {
            imgIcon = unitImages.get((Object)this.type);
        }
        return this.imageIconToTintedBufferedImage(imgIcon);
    }

    private BufferedImage imageIconToTintedBufferedImage(ImageIcon imgIcon) {
        Image img = imgIcon.getImage();
        int width = imgIcon.getIconWidth();
        int height = imgIcon.getIconHeight();
        BufferedImage bufferedImg = new BufferedImage(width, height, 2);
        Graphics2D graphics = bufferedImg.createGraphics();
        graphics.drawImage(img, -5, -4, width, height, null);
        graphics.dispose();
        if (this.color == TeamColor.Red) {
            return Unit.tintImage(TeamColor.Red, bufferedImg, 3);
        }
        return Unit.tintImage(TeamColor.Blue, bufferedImg, 3);
    }

    private static BufferedImage tintImage(TeamColor team, BufferedImage image, int factor) {
        BufferedImage img = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        int x = 0;
        while (x < image.getWidth()) {
            int y = 0;
            while (y < image.getHeight()) {
                int color = image.getRGB(x, y);
                if (team == TeamColor.Red) {
                    int red = Math.min((color >> 16 & 0xFF) + 255 / factor, 255);
                    img.setRGB(x, y, color & 0xFF00FFFF | red << 16);
                } else {
                    int blue = Math.min((color & 0xFF) + 255 / factor, 255);
                    img.setRGB(image.getWidth() - x - 1, y, color & 0xFFFFFF00 | blue);
                }
                ++y;
            }
            ++x;
        }
        return img;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Unit)) {
            return false;
        }
        Unit otherUnit = (Unit)o;
        return this.id == otherUnit.id;
    }
}

