/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;

public class MessageView
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    private static final String FONT = "10px courier, monospace";
    private JEditorPane editorPane;
    private StringBuilder messages;
    private int width = 150;
    private int height;

    private MessageView(JEditorPane editorPane, StringBuilder messages) {
        super(editorPane);
        this.editorPane = editorPane;
        this.messages = messages;
        this.setVerticalScrollBarPolicy(22);
        this.height = (int)Main.findConstant("cBOARD_HEIGHT", 600.0);
        this.setPreferredSize(new Dimension(this.width, this.height));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSystemMessage(String message) {
        MessageView messageView = this;
        synchronized (messageView) {
            if (this.messages.length() != 0) {
                this.messages.append("<br />");
            }
            this.messages.append("<span style=\"font:10px courier, monospace; color:white \">" + message + "</span>");
            this.editorPane.setText(this.messages.toString());
            this.editorPane.setCaretPosition(this.editorPane.getDocument().getLength());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        MessageView messageView = this;
        synchronized (messageView) {
            this.messages.setLength(0);
            this.editorPane.setText("");
        }
    }

    public static MessageView buildMessageView(String content) {
        JEditorPane editorPane = new JEditorPane("text/html", content);
        editorPane.setEditable(false);
        return new MessageView(editorPane, new StringBuilder(content));
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.editorPane.setBackground(Color.BLACK);
    }
}

