/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Scanner;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class Main {
    private static JTextField hostnameField;
    private static JTextField portField;
    private static BoardPanel gameView;
    private static MessageView messageView;
    private static GameConnection gameConnection;
    private static JFrame frame;
    private static boolean disconnecting;
    private static String GAME_NAME;
    private static double GAME_VERSION;
    private static Thread connectionThread;
    public static File CONSTANTS_FILE;

    static {
        GAME_NAME = "Age of Upson";
        GAME_VERSION = 1.0;
        connectionThread = null;
    }

    public static double findConstant(String constantName, double defaultValue) {
        try {
            Scanner sc = new Scanner(CONSTANTS_FILE);
            while (sc.hasNextLine()) {
                String line = sc.nextLine();
                if (!line.matches(String.format("\\s*let\\s+%s\\s*=\\s*([0-9]+|[0-9]+\\.[0-9]*|\\.[0-9]+).*", constantName))) continue;
                int equals = line.indexOf(61);
                int begin = -1;
                int i = equals;
                while (i < line.length()) {
                    if (begin == -1) {
                        if (Character.isDigit(line.charAt(i))) {
                            begin = i;
                        }
                    } else if (!Character.isDigit(line.charAt(i))) {
                        return Double.parseDouble(line.substring(begin, i));
                    }
                    ++i;
                }
                return Double.parseDouble(line.substring(begin));
            }
            System.out.println("not found : " + constantName + "!");
            return defaultValue;
        }
        catch (FileNotFoundException e) {
            return defaultValue;
        }
    }

    public static void addComponentsToFrame(final JFrame frame) throws IOException {
        JPanel bottomPanel = new JPanel();
        JPanel messageAndBottomPanel = new JPanel();
        JPanel messagePanel = new JPanel();
        hostnameField = new JTextField("localhost", 15);
        JLabel hostnameLabel = new JLabel("Hostname:");
        hostnameLabel.setLabelFor(hostnameField);
        portField = new JTextField("10501", 5);
        JLabel portLabel = new JLabel("Port:");
        portLabel.setLabelFor(portField);
        bottomPanel.add(hostnameLabel);
        bottomPanel.add(hostnameField);
        bottomPanel.add(portLabel);
        bottomPanel.add(portField);
        messageView = MessageView.buildMessageView("");
        messageView.addSystemMessage("> Welcome to " + GAME_NAME + " " + GAME_VERSION + "! Please connect to a game server.");
        gameView = new BoardPanel((int)Main.findConstant("cBOARD_WIDTH", 800.0), (int)Main.findConstant("cBOARD_HEIGHT", 600.0), (int)Main.findConstant("cNUM_X_TILES", 20.0), (int)Main.findConstant("cNUM_Y_TILES", 20.0));
        messagePanel.add(messageView);
        messageAndBottomPanel.setLayout(new BorderLayout());
        messageAndBottomPanel.add((Component)bottomPanel, "South");
        frame.add((Component)gameView, "Center");
        frame.add((Component)messageAndBottomPanel, "South");
        final JButton button = new JButton("Connect");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                button.setEnabled(false);
                try {
                    if (gameConnection != null) {
                        button.setText("Disconnecting...");
                        disconnecting = true;
                        gameConnection.close();
                        connectionThread.join();
                        button.setText("Connect");
                        button.setEnabled(true);
                        portField.setEnabled(true);
                        hostnameField.setEnabled(true);
                        Main.gameConnection = null;
                        disconnecting = false;
                        return;
                    }
                    button.setText("Connecting...");
                    Main.gameConnection = new GameConnection(hostnameField.getText(), Integer.parseInt(portField.getText()), gameView, messageView);
                    hostnameField.setEnabled(false);
                    portField.setEnabled(false);
                    button.setText("Disconnect");
                }
                catch (GameException e) {
                    JOptionPane.showMessageDialog(frame, "Error connecting: " + e.getMessage(), "Error connecting", 0);
                    button.setText("Connect");
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                button.setEnabled(true);
                messageView.reset();
                messageView.addSystemMessage("> Connected to game server. Waiting for next game to start.");
                if (gameConnection != null) {
                    connectionThread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                gameConnection.read();
                            }
                            catch (GameException e) {
                                System.out.println(e);
                                if (!disconnecting) {
                                    JOptionPane.showMessageDialog(frame, "Error: " + e.getMessage(), String.valueOf(GAME_NAME) + " Error", 0);
                                }
                                button.setText("Connect");
                                button.setEnabled(true);
                                hostnameField.setEnabled(true);
                                portField.setEnabled(true);
                            }
                        }
                    });
                    connectionThread.start();
                }
            }
        });
        bottomPanel.add(button);
    }

    private static void createAndShowGUI() throws IOException {
        frame = new JFrame(String.valueOf(GAME_NAME) + " " + GAME_VERSION);
        frame.setDefaultCloseOperation(3);
        Main.addComponentsToFrame(frame);
        frame.pack();
        frame.setMinimumSize(frame.getPreferredSize());
        Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
        int frameWidth = frame.getWidth();
        int frameHeight = frame.getHeight();
        int frameCenterX = (int)Math.round((screenDimension.getWidth() - (double)frameWidth) / 2.0);
        int frameCenterY = (int)Math.round((screenDimension.getHeight() - (double)frameHeight) / 2.0);
        frame.setBounds(frameCenterX, frameCenterY, frameWidth, frameHeight);
        frame.setIconImage(Toolkit.getDefaultToolkit().getImage("data/icons/wormsicon.png"));
        frame.setVisible(true);
    }

    public static void main(String[] args) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        CONSTANTS_FILE = args.length > 0 ? new File(args[0]) : new File("../shared/constants.ml");
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Main.createAndShowGUI();
                }
                catch (IOException ex) {
                    throw new GameException(ex);
                }
            }
        });
    }
}

