/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;

public class GameConnection {
    private SocketChannel socketChannel;
    private BoardPanel boardPanel;
    private static final char MESSAGE_DELIMITER = '#';
    private static final String TOKEN_DELIMITER = "$";
    private static final char POINT_DELIMITER = '@';
    private boolean gameStarted = false;

    public GameConnection(String host, int port, BoardPanel boardPanel, MessageView messageView) throws GameException {
        try {
            this.socketChannel = SocketChannel.open(new InetSocketAddress(host, port));
        }
        catch (IOException e) {
            throw new GameException("Unable to open socket.", e);
        }
        this.boardPanel = boardPanel;
    }

    public void close() throws GameException {
        try {
            this.socketChannel.close();
        }
        catch (IOException e) {
            throw new GameException("Error closing socket.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void takeAction(String messageType, List<String> messageArguments) throws GameException {
        if (messageType.equals("AddBuilding")) {
            Integer buildingID = Integer.valueOf(messageArguments.get(0));
            BuildingType buildingType = BuildingType.valueOf(messageArguments.get(1));
            int[] tile = this.getPosition(messageArguments.get(2));
            int health = Integer.parseInt(messageArguments.get(3));
            TeamColor color = TeamColor.valueOf(messageArguments.get(4));
            Map<Integer, Building> map = this.boardPanel.buildings;
            synchronized (map) {
                if (this.boardPanel.buildings.containsKey(buildingID)) {
                    throw new GameException(String.format("AddBuilding: BuildingID already exists (%d)", buildingID));
                }
                Building bld = new Building(buildingID, buildingType, tile[0], tile[1], health, color);
                this.boardPanel.buildings.put(buildingID, bld);
                return;
            }
        }
        if (messageType.equals("AddUnit")) {
            Integer unitID = Integer.valueOf(messageArguments.get(0));
            UnitType unitType = UnitType.valueOf(messageArguments.get(1));
            int[] position = this.getPosition(messageArguments.get(2));
            int health = Integer.parseInt(messageArguments.get(3));
            TeamColor color2 = TeamColor.valueOf(messageArguments.get(4));
            Map<Integer, Unit> map = this.boardPanel.units;
            synchronized (map) {
                if (this.boardPanel.units.containsKey(unitID)) {
                    throw new GameException(String.format("AddUnit: UnitID already exists (%d)", unitID));
                }
                Unit u = new Unit(unitID, unitType, position[0], position[1], health, color2);
                this.boardPanel.units.put(unitID, u);
                return;
            }
        }
        if (messageType.equals("Countdown")) {
            String unitID = this.boardPanel.overlayText;
            synchronized (unitID) {
                this.boardPanel.overlayText = !messageArguments.get(0).equals("0") ? messageArguments.get(0) : "";
                return;
            }
        }
        if (messageType.equals("DisplayString")) {
            String color = messageArguments.get(0);
            String message = messageArguments.get(1);
            this.checkEasterEgg(message);
            this.checkAudio(message);
            int i = 0;
            while (i < this.boardPanel.message.length - 1) {
                this.boardPanel.message[i] = this.boardPanel.message[i + 1];
                ++i;
            }
            this.boardPanel.message[this.boardPanel.message.length - 1] = String.valueOf(color) + ": " + message;
            return;
        }
        if (messageType.equals("DoCollect")) {
            String color = messageArguments.get(0);
            String resource = messageArguments.get(1);
            int amount = Integer.parseInt(messageArguments.get(2));
            int index = color.equals("Red") ? 0 : 1;
            int[] color2 = this.boardPanel.food;
            synchronized (this.boardPanel.food) {
                int[] nArray = this.boardPanel.wood;
                synchronized (this.boardPanel.wood) {
                    if (resource.equals("Food")) {
                        int n = index;
                        this.boardPanel.food[n] = this.boardPanel.food[n] + amount;
                    } else {
                        int n = index;
                        this.boardPanel.wood[n] = this.boardPanel.wood[n] + amount;
                    }
                    // ** MonitorExit[var8_76] (shouldn't be in output)
                    return;
                }
            }
        }
        if (messageType.equals("GameOver")) {
            String output = messageArguments.get(0);
            String resource = this.boardPanel.overlayText;
            synchronized (resource) {
                this.boardPanel.overlayText = output.equals("Tie") ? "The game was a tie!" : "Team " + output + " won!";
                return;
            }
        }
        if (messageType.equals("MoveUnit")) {
            Integer unitID = Integer.valueOf(messageArguments.get(0));
            TeamColor color = TeamColor.valueOf(messageArguments.get(1));
            if (messageArguments.size() <= 1) return;
            ArrayList<Pair<Integer, Integer>> path = new ArrayList<Pair<Integer, Integer>>();
            int i22 = 2;
            while (i22 < messageArguments.size()) {
                int[] pos = this.getPosition(messageArguments.get(i22));
                Pair<Integer, Integer> p = new Pair<Integer, Integer>(pos[0], pos[1]);
                path.add(p);
                ++i22;
            }
            Map<Integer, Unit> i22 = this.boardPanel.units;
            synchronized (i22) {
                if (!this.boardPanel.units.containsKey(unitID)) {
                    throw new GameException(String.format("MoveUnit: UnitID doesn't exist (%d)", unitID));
                }
                Unit u = this.boardPanel.units.get(unitID);
                u.addMove(path);
                return;
            }
        }
        if (messageType.equals("StopUnit")) {
            Integer unitID = Integer.valueOf(messageArguments.get(0));
            int[] position = this.getPosition(messageArguments.get(2));
            Map<Integer, Unit> path = this.boardPanel.units;
            synchronized (path) {
                if (!this.boardPanel.units.containsKey(unitID)) {
                    throw new GameException(String.format("MoveUnit: UnitID doesn't exist (%d)", unitID));
                }
                Unit u = this.boardPanel.units.get(unitID);
                u.clearMove(position);
                return;
            }
        }
        if (messageType.equals("UpdateResource")) {
            int[] tile = this.getPosition(messageArguments.get(0));
            int resourceCount = Integer.valueOf(messageArguments.get(1));
            int r = tile[0];
            int c2 = tile[1];
            ArrayList<Resource> resources = new ArrayList<Resource>();
            ArrayList<Resource> p = this.boardPanel.berryBushes;
            synchronized (p) {
                ArrayList<Resource> u = this.boardPanel.trees;
                synchronized (u) {
                    resources.addAll(this.boardPanel.berryBushes);
                    resources.addAll(this.boardPanel.trees);
                    for (Resource resource : resources) {
                        if (r != resource.row || c2 != resource.column) continue;
                        resource.count = resourceCount;
                        break;
                    }
                }
                return;
            }
        }
        if (messageType.equals("RemoveResource")) {
            int[] tile = this.getPosition(messageArguments.get(0));
            int r = tile[0];
            int c = tile[1];
            ArrayList<Resource> c2 = this.boardPanel.berryBushes;
            synchronized (c2) {
                ArrayList<Resource> arrayList = this.boardPanel.trees;
                synchronized (arrayList) {
                    ArrayList<Resource> p = this.boardPanel.grassHack;
                    synchronized (p) {
                        Resource res = null;
                        ArrayList<Resource> body = null;
                        for (Resource resource : this.boardPanel.trees) {
                            if (r != resource.row || c != resource.column) continue;
                            res = resource;
                            body = this.boardPanel.trees;
                            break;
                        }
                        for (Resource resource : this.boardPanel.berryBushes) {
                            if (r != resource.row || c != resource.column) continue;
                            res = resource;
                            body = this.boardPanel.berryBushes;
                            break;
                        }
                        body.remove(res);
                        this.boardPanel.grassHack.add(res);
                    }
                }
                return;
            }
        }
        if (messageType.equals("UpgradeAge")) {
            TeamColor color = TeamColor.valueOf(messageArguments.get(0));
            Map<Integer, Building> r = this.boardPanel.buildings;
            synchronized (r) {
                for (Building b : this.boardPanel.buildings.values()) {
                    if (b.color == color && b.type == BuildingType.TownCenter) {
                        b.type = BuildingType.EliteTownCenter;
                        continue;
                    }
                    if (b.color != color || b.type != BuildingType.Barracks) continue;
                    b.type = BuildingType.EliteBarracks;
                }
                return;
            }
        }
        if (messageType.equals("UpgradeUnit")) {
            UnitType ut = UnitType.valueOf(messageArguments.get(0));
            TeamColor color = TeamColor.valueOf(messageArguments.get(1));
            UnitType new_type = null;
            UnitType other_type = null;
            if (ut == UnitType.Archer) {
                new_type = UnitType.EliteArcher;
                other_type = UnitType.EliteArcher;
            } else if (ut == UnitType.EliteArcher) {
                new_type = UnitType.EliteArcher;
                other_type = UnitType.Archer;
            } else if (ut == UnitType.Pikeman) {
                new_type = UnitType.ElitePikeman;
                other_type = UnitType.ElitePikeman;
            } else if (ut == UnitType.ElitePikeman) {
                new_type = UnitType.ElitePikeman;
                other_type = UnitType.Pikeman;
            } else if (ut == UnitType.Knight) {
                new_type = UnitType.EliteKnight;
                other_type = UnitType.EliteKnight;
            } else if (ut == UnitType.EliteKnight) {
                new_type = UnitType.EliteKnight;
                other_type = UnitType.Knight;
            }
            Map<Integer, Unit> map = this.boardPanel.units;
            synchronized (map) {
                for (Unit u : this.boardPanel.units.values()) {
                    if (u.color != color || u.type != ut && u.type != other_type) continue;
                    u.type = new_type;
                }
                return;
            }
        }
        if (messageType.equals("UpdateScore")) {
            TeamColor color = TeamColor.valueOf(messageArguments.get(0));
            int sc = Integer.parseInt(messageArguments.get(1));
            int[] new_type = this.boardPanel.score;
            synchronized (this.boardPanel.score) {
                if (color == TeamColor.Red) {
                    this.boardPanel.score[0] = sc;
                } else {
                    this.boardPanel.score[1] = sc;
                }
                // ** MonitorExit[new_type] (shouldn't be in output)
                return;
            }
        }
        if (messageType.equals("UpdateBuilding")) {
            int id = Integer.parseInt(messageArguments.get(0));
            int health = Integer.parseInt(messageArguments.get(1));
            Map<Integer, Building> new_type = this.boardPanel.buildings;
            synchronized (new_type) {
                for (Building b : this.boardPanel.buildings.values()) {
                    if (b.id != id) continue;
                    b.health = health;
                    break;
                }
                return;
            }
        }
        if (messageType.equals("UpdateUnit")) {
            int id = Integer.parseInt(messageArguments.get(0));
            int health = Integer.parseInt(messageArguments.get(1));
            Map<Integer, Unit> new_type = this.boardPanel.units;
            synchronized (new_type) {
                for (Unit u : this.boardPanel.units.values()) {
                    if (u.id != id) continue;
                    u.health = health;
                    break;
                }
                return;
            }
        }
        if (messageType.equals("RemoveUnit")) {
            int id = Integer.parseInt(messageArguments.get(0));
            Map<Integer, Unit> map = this.boardPanel.units;
            synchronized (map) {
                this.boardPanel.units.remove(id);
                return;
            }
        }
        if (messageType.equals("RemoveBuilding")) {
            int id = Integer.parseInt(messageArguments.get(0));
            Map<Integer, Building> map = this.boardPanel.buildings;
            synchronized (map) {
                this.boardPanel.buildings.remove(id);
                return;
            }
        }
        if (!messageType.equals("DoAttack")) return;
        int id = Integer.parseInt(messageArguments.get(0));
        Map<Integer, Unit> map = this.boardPanel.units;
        synchronized (map) {
            for (Unit u : this.boardPanel.units.values()) {
                if (u.id != id) continue;
                u.attack = 0;
                break;
            }
            return;
        }
    }

    private void checkAudio(String message) {
        try {
            int file = Integer.parseInt(message);
            String f = "";
            if (file > 0 && file < 10) {
                f = "0" + file + ".mp3";
            } else if (file > 9 && file < 43) {
                f = String.valueOf(file) + ".mp3";
            } else {
                return;
            }
            MP3 mp3 = new MP3("audio/" + f);
            mp3.play();
        }
        catch (NumberFormatException e) {
            return;
        }
    }

    private void checkEasterEgg(String message) {
        if (message.equals("Greganator")) {
            try {
                this.boardPanel.backgroundImage = ImageIO.read(new File("images" + File.separator + "greg.jpeg"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (message.equals("LOL Ranjay!")) {
            message = "Easter Egg enabled";
        }
    }

    public int[] getPosition(String s) {
        int[] arr = new int[2];
        int index = s.indexOf(64);
        arr[0] = Integer.parseInt(s.substring(0, index));
        arr[1] = Integer.parseInt(s.substring(index + 1));
        return arr;
    }

    public void read() throws GameException {
        try {
            System.out.println("Reading...");
            StringBuilder sb = new StringBuilder();
            ByteBuffer bb = ByteBuffer.allocate(4096);
            while (true) {
                long numChar;
                if ((numChar = (long)this.socketChannel.read(bb)) == -1L) {
                    this.close();
                    throw new GameException("Connection closed.");
                }
                if (numChar == 0L) continue;
                bb.rewind();
                while (numChar-- > 0L) {
                    char nextChar = (char)bb.get();
                    if (nextChar != '#') {
                        sb.append(nextChar);
                        continue;
                    }
                    if (sb.length() == 0) continue;
                    StringTokenizer st = new StringTokenizer(sb.toString(), TOKEN_DELIMITER);
                    if (st.countTokens() <= 0) {
                        System.err.println("Received invalid message: " + sb.toString());
                        continue;
                    }
                    String messageType = st.nextToken();
                    ArrayList<String> messageArguments = new ArrayList<String>();
                    while (st.hasMoreTokens()) {
                        messageArguments.add(st.nextToken());
                    }
                    try {
                        try {
                            int[] pos;
                            if (messageType.equals("InitGraphics")) {
                                this.boardPanel.resetState();
                                int soundtrackNum = (int)(Math.random() * 9.0);
                                MP3 mp3 = new MP3("audio/soundtrack" + soundtrackNum + ".mp3");
                                mp3.play();
                                this.gameStarted = true;
                                continue;
                            }
                            if (messageType.equals("InitFood")) {
                                int startingFoodCount = (int)Main.findConstant("cINITIAL_FOOD", 150.0);
                                int i = 0;
                                while (i < messageArguments.size()) {
                                    pos = this.getPosition((String)messageArguments.get(i));
                                    this.boardPanel.berryBushes.add(new Resource(pos[0], pos[1], startingFoodCount, ResourceType.Food));
                                    ++i;
                                }
                                this.boardPanel.drawFood();
                                continue;
                            }
                            if (messageType.equals("InitWood")) {
                                int startingWoodCount = (int)Main.findConstant("cINITIAL_WOOD", 150.0);
                                int i = 0;
                                while (i < messageArguments.size()) {
                                    pos = this.getPosition((String)messageArguments.get(i));
                                    this.boardPanel.trees.add(new Resource(pos[0], pos[1], startingWoodCount, ResourceType.Wood));
                                    ++i;
                                }
                                this.boardPanel.drawWood();
                                continue;
                            }
                            if (this.gameStarted) {
                                this.takeAction(messageType, messageArguments);
                                continue;
                            }
                            throw new GameException("Game has not yet been initialized: " + messageType);
                        }
                        catch (RuntimeException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            System.err.println("Error decoding message: " + sb.toString());
                            sb.setLength(0);
                        }
                    }
                    finally {
                        sb.setLength(0);
                    }
                }
                bb.clear();
            }
        }
        catch (AsynchronousCloseException e) {
            throw new GameException("Connection closed.", e);
        }
        catch (IOException e) {
            throw new GameException("Failed to read from socket.", e);
        }
    }
}

