/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class Building {
    private static Map<Pair<TeamColor, BuildingType>, BufferedImage> buildingImages;
    private static Map<BuildingType, Integer> maxHealthMap;
    public int id;
    public int row;
    public int column;
    public int health;
    public int maxHealth;
    public BuildingType type;
    public TeamColor color;

    static {
        int tintFactor = 3;
        maxHealthMap = new HashMap<BuildingType, Integer>();
        buildingImages = new HashMap<Pair<TeamColor, BuildingType>, BufferedImage>();
        try {
            String[] list = new String[]{Const.TOWNCENTER_IMAGE, Const.BARRACKS_IMAGE, Const.ELITE_TOWNCENTER_IMAGE, Const.ELITE_BARRACKS_IMAGE};
            BuildingType[] typeList = new BuildingType[]{BuildingType.TownCenter, BuildingType.Barracks, BuildingType.EliteTownCenter, BuildingType.EliteBarracks};
            int i = 0;
            while (i < list.length) {
                BufferedImage img = ImageIO.read(new File(String.format("%s", list[i])));
                BufferedImage red = Building.tintImage(TeamColor.Red, img, 3);
                BufferedImage blue = Building.tintImage(TeamColor.Blue, img, 3);
                buildingImages.put(new Pair<TeamColor, BuildingType>(TeamColor.Red, typeList[i]), red);
                buildingImages.put(new Pair<TeamColor, BuildingType>(TeamColor.Blue, typeList[i]), blue);
                ++i;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Building(int id, BuildingType type, int row, int column, int health, TeamColor color) {
        this.id = id;
        this.type = type;
        this.row = row;
        this.column = column;
        this.health = health;
        this.maxHealth = health;
        this.color = color;
    }

    public BufferedImage getTypeImage() {
        return buildingImages.get(new Pair<TeamColor, BuildingType>(this.color, this.type));
    }

    private static BufferedImage tintImage(TeamColor team, BufferedImage image, int factor) {
        BufferedImage img = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        int x = 0;
        while (x < image.getWidth()) {
            int y = 0;
            while (y < image.getHeight()) {
                int color = image.getRGB(x, y);
                if (team == TeamColor.Red) {
                    int red = Math.min((color >> 16 & 0xFF) + 255 / factor, 255);
                    img.setRGB(x, y, color & 0xFF00FFFF | red << 16);
                } else {
                    int blue = Math.min((color & 0xFF) + 255 / factor, 255);
                    img.setRGB(image.getWidth() - x - 1, y, color & 0xFFFFFF00 | blue);
                }
                ++y;
            }
            ++x;
        }
        return img;
    }
}

