/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class BoardPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int FRAME_DELAY = 30;
    public BufferedImage backgroundImage;
    private int width;
    private int height;
    private int numx;
    private int numy;
    private int tileWidth;
    private int tileHeight;
    public Map<Integer, Unit> units;
    public Map<Integer, Building> buildings;
    public ArrayList<Resource> trees;
    public ArrayList<Resource> berryBushes;
    public ArrayList<Resource> grassHack;
    public int[] score;
    public int[] food;
    public int[] wood;
    public ArrayList<Aesthetics> aesthetics;
    public String overlayText;
    private final Font TEXT_FONT = new Font("Tacoma", 1, 36);
    private final int PADDING = 20;
    private final int HEALTH_BAR_OFFSET = 2;
    private final int HEALTH_BAR_WIDTH = 4;
    private final int HEALTH_BAR_HEIGHT = 30;
    private final int HEALTH_BAR_BORDER = 1;
    public String[] message = new String[5];

    public BoardPanel(int width, int height, int nx, int ny) {
        this.message[4] = "Welcome to Age of Upson! Please connect to a game server.";
        this.message[0] = "";
        this.message[1] = "";
        this.message[2] = "";
        this.message[3] = "";
        this.width = width;
        this.height = height;
        this.numx = nx;
        this.numy = ny;
        this.tileWidth = width / this.numx;
        this.tileHeight = height / this.numy;
        Dimension d = new Dimension(width, height);
        this.setPreferredSize(d);
        this.setDoubleBuffered(true);
        this.overlayText = "";
        this.score = new int[2];
        this.food = new int[2];
        this.wood = new int[2];
        this.units = new HashMap<Integer, Unit>();
        this.buildings = new HashMap<Integer, Building>();
        this.trees = new ArrayList();
        this.berryBushes = new ArrayList();
        this.grassHack = new ArrayList();
        this.aesthetics = new ArrayList();
        this.createBackground();
        this.createAesthetic();
        this.startRepaintLoop();
    }

    private void createAesthetic() {
        Random r = new Random();
        int i = 0;
        while (i < 10) {
            String img = "";
            switch (r.nextInt(4)) {
                case 0: {
                    img = Const.AESTHETIC5;
                    break;
                }
                case 1: {
                    img = Const.AESTHETIC2;
                    break;
                }
                case 2: {
                    img = Const.AESTHETIC3;
                    break;
                }
                case 3: {
                    img = Const.AESTHETIC4;
                }
            }
            this.aesthetics.add(new Aesthetics(r.nextInt(this.numy), r.nextInt(this.numx), img));
            ++i;
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        if (this.backgroundImage != null) {
            g2d.drawImage((Image)this.backgroundImage, 0, 0, null);
            this.drawAsthetic(g2d);
            this.drawFood();
            this.drawWood();
            this.drawGrass();
            this.drawBuildings(g2d);
            this.drawUnits(g2d);
            this.drawScores(g2d);
            this.drawFoodWood(g2d);
            this.drawOverlayText(g2d);
            this.drawMessages(g2d);
        } else {
            g2d.setPaint(Color.BLACK);
            g2d.fillRect(0, 0, this.width, this.height);
        }
    }

    private void drawMessages(Graphics2D g2d) {
        g2d.setFont(new Font("Tacoma", 1, 10));
        g2d.setColor(Color.WHITE);
        g2d.drawString(this.message[0], 20, this.height - 100);
        g2d.drawString(this.message[1], 20, this.height - 80);
        g2d.drawString(this.message[2], 20, this.height - 60);
        g2d.drawString(this.message[3], 20, this.height - 40);
        g2d.drawString(this.message[4], 20, this.height - 20);
    }

    private void drawAsthetic(Graphics2D g2d) {
        for (Aesthetics as : this.aesthetics) {
            BufferedImage image = as.image;
            int r = as.row;
            int c = as.column;
            g2d.drawImage(image, c * this.tileWidth, r * this.tileHeight, this.tileWidth, this.tileHeight, null);
        }
    }

    public void createBackground() {
        BufferedImage grassImage;
        try {
            grassImage = ImageIO.read(new File("images" + File.separator + "grass.jpg"));
        }
        catch (IOException e) {
            throw new GameException("Images not found.");
        }
        this.backgroundImage = new BufferedImage(this.width, this.height, 1);
        Graphics2D imageG2d = (Graphics2D)this.backgroundImage.getGraphics();
        imageG2d.setPaint(new TexturePaint(grassImage, new Rectangle(0, 0, grassImage.getWidth(), grassImage.getHeight())));
        imageG2d.fillRect(0, 0, this.width, this.height);
    }

    private void drawResourceHealthBar(Graphics2D g2d, Resource resource, int r, int c) {
        int healthBarOriginX = c * this.tileWidth + this.tileWidth / 2 + 2 + 8;
        int healthBarOriginY = r * this.tileHeight + this.tileHeight / 2 + 8;
        int height = 15;
        g2d.setColor(Color.BLACK);
        g2d.fillRect(healthBarOriginX - 1, healthBarOriginY - height - 1, 6, height + 2);
        g2d.setColor(Color.GRAY);
        g2d.fillRect(healthBarOriginX, healthBarOriginY - height, 4, height);
        double factor = (double)resource.count / (double)resource.maxCount;
        if (factor < 0.2) {
            g2d.setColor(Color.RED);
        } else if (factor < 0.5) {
            g2d.setColor(Color.YELLOW);
        } else {
            g2d.setColor(Color.GREEN);
        }
        g2d.fillRect(healthBarOriginX, healthBarOriginY - (int)((double)height * factor), 4, (int)((double)height * factor));
    }

    public void drawFood() {
        BufferedImage image;
        try {
            image = ImageIO.read(new File(Const.FOOD_IMAGE));
        }
        catch (IOException e) {
            throw new GameException("Food image not found.");
        }
        Graphics2D g2d = (Graphics2D)this.backgroundImage.getGraphics();
        for (Resource food : this.berryBushes) {
            int r = food.row;
            int c = food.column;
            g2d.drawImage(image, c * this.tileWidth, r * this.tileHeight, this.tileWidth, this.tileHeight, null);
            this.drawResourceHealthBar(g2d, food, r, c);
        }
    }

    public void drawWood() {
        BufferedImage woodImage;
        try {
            woodImage = ImageIO.read(new File(Const.WOOD_IMAGE));
        }
        catch (IOException e) {
            throw new GameException("Wood image not found.");
        }
        Graphics2D g2d = (Graphics2D)this.backgroundImage.getGraphics();
        for (Resource wood : this.trees) {
            int r = wood.row;
            int c = wood.column;
            g2d.drawImage(woodImage, c * this.tileWidth, r * this.tileHeight, this.tileWidth, this.tileHeight, null);
            this.drawResourceHealthBar(g2d, wood, r, c);
        }
    }

    public void drawGrass() {
        BufferedImage woodImage;
        try {
            woodImage = ImageIO.read(new File(Const.GRASS_IMAGE));
        }
        catch (IOException e) {
            throw new GameException("grass image not found.");
        }
        Graphics2D g2d = (Graphics2D)this.backgroundImage.getGraphics();
        for (Resource res : this.grassHack) {
            int r = res.row;
            int c = res.column;
            g2d.drawImage(woodImage, c * this.tileWidth, r * this.tileHeight, this.tileWidth, this.tileHeight, null);
        }
    }

    private void drawOverlayText(Graphics2D g2d) {
        if (!this.overlayText.equals("")) {
            int stringWidth = g2d.getFontMetrics(this.TEXT_FONT).stringWidth(this.overlayText);
            int stringX = (this.width - stringWidth) / 2;
            int stringY = (this.height - 20) / 2;
            g2d.setColor(Color.WHITE);
            g2d.fillRoundRect(stringX - 20, stringY - 20 - 30, stringWidth + 40, 70, 10, 10);
            g2d.setColor(Color.BLACK);
            g2d.drawRoundRect(stringX - 20, stringY - 20 - 30, stringWidth + 40, 70, 10, 10);
            g2d.setFont(this.TEXT_FONT);
            g2d.drawString(this.overlayText, stringX, stringY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawScores(Graphics2D g2d) {
        int[] nArray = this.score;
        synchronized (this.score) {
            String score1 = String.valueOf(this.score[0]);
            String score2 = String.valueOf(this.score[1]);
            // ** MonitorExit[var4_2] (shouldn't be in output)
            g2d.setFont(new Font("Tacoma", 1, 20));
            g2d.setColor(Color.RED);
            g2d.drawString(score1, 20, 40);
            g2d.setColor(Color.BLUE);
            g2d.drawString(score2, this.width - score2.length() * 20 - 10, 40);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawFoodWood(Graphics2D g2d) {
        int[] nArray = this.food;
        synchronized (this.food) {
            String food1 = "Food: " + String.valueOf(this.food[0]);
            String food2 = "Food: " + String.valueOf(this.food[1]);
            // ** MonitorExit[var4_2] (shouldn't be in output)
            g2d.setFont(new Font("Tacoma", 1, 16));
            g2d.setColor(Color.RED);
            g2d.drawString(food1, 20, 60);
            g2d.setColor(Color.BLUE);
            g2d.drawString(food2, this.width - food2.length() * 10 - 10, 60);
            int[] nArray2 = this.food;
            synchronized (this.food) {
                String wood1 = "Wood: " + String.valueOf(this.wood[0]);
                String wood2 = "Wood: " + String.valueOf(this.wood[1]);
                // ** MonitorExit[var6_5] (shouldn't be in output)
                g2d.setFont(new Font("Tacoma", 1, 16));
                g2d.setColor(Color.RED);
                g2d.drawString(wood1, 20, 80);
                g2d.setColor(Color.BLUE);
                g2d.drawString(wood2, this.width - wood2.length() * 10 - 10, 80);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawUnits(Graphics2D g2d) {
        Map<Integer, Unit> map = this.units;
        synchronized (map) {
            for (Integer key : this.units.keySet()) {
                Unit u = this.units.get(key);
                u.updateLocation();
                BufferedImage image = u.getTypeImage();
                int x = u.x;
                int y = u.y;
                int xOrigin = x;
                int yOrigin = y;
                double sizeMult = 0.75;
                g2d.drawImage(image, xOrigin - image.getWidth() / 2, yOrigin - image.getHeight(), (int)(sizeMult * (double)image.getWidth()), (int)(sizeMult * (double)image.getHeight()), null);
                int healthBarOriginX = xOrigin + image.getWidth() / 2 + 2;
                int healthBarOriginY = yOrigin - 10;
                g2d.setColor(Color.BLACK);
                g2d.fillRect(healthBarOriginX - 1, healthBarOriginY - 30 - 1, 6, 32);
                g2d.setColor(Color.GRAY);
                g2d.fillRect(healthBarOriginX, healthBarOriginY - 30, 4, 30);
                double factor = (double)u.health / (double)u.maxHealth;
                if (factor < 0.2) {
                    g2d.setColor(Color.RED);
                } else if (factor < 0.5) {
                    g2d.setColor(Color.YELLOW);
                } else {
                    g2d.setColor(Color.GREEN);
                }
                g2d.fillRect(healthBarOriginX, healthBarOriginY - (int)(30.0 * factor), 4, (int)(30.0 * factor));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawBuildings(Graphics2D g2d) {
        Map<Integer, Building> map = this.buildings;
        synchronized (map) {
            for (Integer key : this.buildings.keySet()) {
                Building b = this.buildings.get(key);
                BufferedImage image = b.getTypeImage();
                int c = b.column;
                int r = b.row;
                int xOrigin = c * this.tileWidth;
                int yOrigin = r * this.tileHeight;
                g2d.drawImage(image, xOrigin, yOrigin, this.tileWidth * 2, this.tileHeight * 2, null);
                int healthBarOriginX = xOrigin + this.tileWidth * 2 - 10;
                int healthBarOriginY = yOrigin + 5;
                g2d.setColor(Color.BLACK);
                g2d.fillRect(healthBarOriginX - 1, healthBarOriginY - 1, 6, 32);
                g2d.setColor(Color.GRAY);
                g2d.fillRect(healthBarOriginX, healthBarOriginY, 4, 30);
                double factor = (double)b.health / (double)b.maxHealth;
                if (factor < 0.2) {
                    g2d.setColor(Color.RED);
                } else if (factor < 0.5) {
                    g2d.setColor(Color.YELLOW);
                } else {
                    g2d.setColor(Color.GREEN);
                }
                g2d.fillRect(healthBarOriginX, healthBarOriginY + (int)(30.0 * (1.0 - factor)), 4, (int)(30.0 * factor));
            }
        }
    }

    public void drawTownCenters(int[] rowPoints, int[] colPoints) {
        BufferedImage townCenterImage;
        try {
            townCenterImage = ImageIO.read(new File(Const.TOWNCENTER_IMAGE));
        }
        catch (IOException e) {
            throw new GameException("Town Center image not found.");
        }
        if (rowPoints.length > 2 || colPoints.length > 2) {
            throw new GameException("Too many town centers. Game is currently only supported for 2 players.");
        }
        Graphics2D imageG2d = (Graphics2D)this.backgroundImage.getGraphics();
        int i = 0;
        while (i < rowPoints.length) {
            int r = rowPoints[i];
            int c = colPoints[i];
            imageG2d.drawImage(townCenterImage, c * this.tileWidth, r * this.tileHeight, this.tileWidth * 2, this.tileHeight * 2, null);
            ++i;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    public void resetState() {
        this.units = new HashMap<Integer, Unit>();
        this.buildings = new HashMap<Integer, Building>();
        this.trees.clear();
        this.berryBushes.clear();
        this.grassHack.clear();
        this.createBackground();
        this.score = new int[2];
        this.food = new int[2];
        this.wood = new int[2];
    }

    public void startRepaintLoop() {
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    BoardPanel.this.repaint();
                                }
                            });
                            Thread.sleep(30L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }
}

