/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class BackgroundGUI {
    public static void setUpBackground(JPanel panel, int numx, int numy, int width, int height) {
        panel.setLayout(new GridLayout(numx, numy));
        JPanel[][] panels = BackgroundGUI.setupField(numx, numy, width, height);
        int x = 0;
        while (x < numy) {
            int y = numx - 1;
            while (y >= 0) {
                panel.add(panels[x][y]);
                --y;
            }
            ++x;
        }
    }

    public static JPanel[][] setupField(int numx, int numy, int width, int height) {
        JPanel[][] panels = new JPanel[numy][numx];
        try {
            BufferedImage foodImage = ImageIO.read(new File("images" + File.separator + "food.png"));
            BufferedImage grassImage = ImageIO.read(new File("images" + File.separator + "grass.jpg"));
            BufferedImage woodImage = ImageIO.read(new File("images" + File.separator + "tree.png"));
            BufferedImage townCenterImage = ImageIO.read(new File("images" + File.separator + "towncenter.gif"));
            int i = 0;
            while (i < numy) {
                int j = 0;
                while (j < numx) {
                    panels[i][j] = new MiniPanel(width / numy, height / numx, foodImage);
                    ++j;
                }
                ++i;
            }
            panels[0][0] = new MiniPanel(width / numy, height / numx, grassImage, townCenterImage);
            panels[numy - 1][numx - 1] = new MiniPanel(width / numy, height / numx, grassImage, townCenterImage);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return panels;
    }

    private static String parseLine(String line) {
        String s = "";
        int i = 0;
        while (i < line.length()) {
            if (line.charAt(i) != ' ') {
                s = String.valueOf(s) + line.charAt(i);
            }
            ++i;
        }
        return s;
    }
}

