package edu.cornell.cs.cs2110;

import java.util.LinkedList;
import java.util.NoSuchElementException;

/**
 * A FIFO implementation of the {@link Bag} interface.
 *
 * @param <T>
 *           the type of elements contained in this {@code Queue}.
 */
public class Queue<T> extends AbstractBag<T> {
   
   private LinkedList<T> queue = new LinkedList<T>();
   
   /**
    * {@inheritDoc}
    */
   public void insert(T item) {
      queue.add(item);      
   }
   
   /**
    * {@inheritDoc}
    */
   public T extract() throws NoSuchElementException {
      return queue.remove();      
   }

   /**
    * {@inheritDoc}
    */
   public void clear() {
      queue.clear();      
   }

   /**
    * {@inheritDoc}
    */
   public int size() {
      return queue.size();
   }
}