type huffmantree = int (*you might want to change this...*)
type encoding = char * (int list)

(* Returns an array with the frequency of appearance of each character
	 in cl stored in its ASCII-based index *)
let countchars (cl : char list) : int array =
	let ar = Array.make 256 0 in
  List.iter (fun elt -> ar.(int_of_char elt) <- (ar.(int_of_char elt) + 1)) cl;
	ar

(* Returns a list of all encodings stored in hm *)
let get_codes (hm : huffmantree) : encoding list =
	failwith "not implemented"

(* Returns the longest encoding in encl*)
let longest_code (encl : encoding list) : int list =
	failwith "not implemented"

(* Returns the bit vector in encl that encodes chr *)
let lookup_code (chr: char) (encl : encoding list) : int list =
	failwith "not implemented"

(* Returns the huffman tree created from cl and the encoded bit stream*)
let encode (cl : char list) : huffmantree * int list=
	failwith "not implemented"

(* Returns the char list decoded from bitstream, based on the bit vectors
 	 in hm *)
let decode (hm : huffmantree) (bitstream: int list) : char list =
	failwith "not implemented"

(* Returns bitstream with hm compressed and stored on the beginning of the
	 stream in preorder *)
let prepend_tree (hm : huffmantree) (bitstream: int list) : int list =
	failwith "not implemented"

(* Returns bitstream with the encoding for a huffman tree removed from the
	 beginning and decoded.
	 Requires: a valid encoding for a huffman tree at the beginning of
	 bitstream *)
let regrow_tree (bitstream : int list) : huffmantree * int list =
	failwith "not implemented"

let encode_file (fname : string) : unit =
  let (hm, codelist) = encode (Util.load_chars fname) in
  let prepended = prepend_tree hm codelist in
  let compressedf = open_out_bin (fname ^ "-compressed.txt") in
  Util.write_bits compressedf prepended (longest_code (get_codes hm));
  close_out compressedf

let decode_file (fname : string) : unit =
  let readcompf = open_in_bin (fname ^ "-compressed.txt") in
  let decodedf = open_out (fname ^ "-decoded.txt") in
  let readin = Util.read_bits readcompf in
  let (regrown, bitstream) = regrow_tree readin in
  let chrs = decode regrown bitstream in
  Util.write_chars decodedf chrs;
  close_in readcompf;
  close_out decodedf

let main (fname : string) : unit =
  encode_file fname; decode_file fname

