(* Maximum weight independent set in a tree *)
(* AKA the office party optimization problem *)
type tree = Empty | Node of int * tree * tree

(* Returns optimum fun for t *)
let rec party t : int = max (party_in t) (party_out t)

(* Returns optimum fun for t assuming the root node of t is included *)
and party_in t =
  match t with 
    Empty -> 0
  | Node (v, left, right) -> v + party_out left + party_out right

(* Returns optimum fun for t assuming the root node of t is excluded *)
and party_out t =
  match t with
    Empty -> 0
  | Node (v, left, right) -> party left + party right
