(* Same spec as linebreak1.
   Performance: worst-case time is linear in the number of words. *)
let linebreak2 (words : string list) (target : int) : string list =
  let memo : breakResult option array = 
    Array.create (List.length words + 1) None in
  let rec lb_mem (words : string list) : breakResult =
    let n = List.length words in
    match Array.get memo n with
      Some br -> br
    | None -> let br = lb 0 words in
        Array.set memo n (Some br); br
  and lb (clen : int) (words : string list) : breakResult =
    match words with
      [] -> ([""], 0) (* no charge for last line *)
    | word :: rest ->
        let wlen = String.length word in
        let contlen = if clen = 0 then wlen else clen + 1 + wlen in
        let (l1, c1') = lb_mem rest in
        let c1 = c1' + cube (target - contlen) in
        if contlen > target then (word :: l1, big)
        else
          let (h2 :: t2, c2) = lb contlen rest in
          if c1 < c2 then (word :: l1, c1)
                     else ((if h2 = ""
                            then word
                            else word ^ " " ^ h2) :: t2, c2) in
  let (result, cost) = lb 0 words in
  result