(* Straightforward implementation of fib has exponential number of
 * recursive calls. Requires n non-negative *)
let rec fib n = if n < 2 then 1 else fib (n-1) + fib (n-2)

(* However most of these recursive calls share common subproblems -
 * there are only n distinct subproblems to solve, one for each value
 * of n.  The idea of memoization is to keep track of these results so
 * they can be looked up rather than recomputed. *)
let fibm n =
  let memo : int option array = Array.create (n+1) None in
  let rec f_mem n =
    match memo.(n) with
      Some result -> result       (* computed already! *)
    | None ->
        let result = if n < 2 then 1 else f_mem (n-1) + f_mem (n-2) in
        memo.(n) <- Some result;  (* record in table *)
        result
  in f_mem n
