(* This version memoizes the optimal fun value for each tree node.
   It also remembers the best invite list. Each tree node has the
   name of the employee as a string. *)
type tree = Empty
  | Node of int * string * tree * tree *
  (int * string list) option ref

let rec party t : int * string list =
  match t with
    Empty -> (0, [])
  | Node (v, name, left, right, memo) ->
      match !memo with
        Some result -> result
      | None ->
          let (infun, innames) = party_in t in
          let (outfun, outnames) = party_out t in
          let result =
            if infun > outfun then (v + infun, name :: innames)
            else (outfun, outnames) in
          memo := Some result; result

and party_in t =
  match t with
    Empty -> (0, [])
  | Node (v, name, l, r, _) ->
      let (lfun, lnames) = party_out l
      and (rfun, rnames) = party_out r in
      (v + lfun + rfun, name :: lnames @ rnames)

and party_out t =
  match t with
    Empty -> (0, [])
  | Node (v, _, l, r, _) ->
      let (lfun, lnames) = party l
      and (rfun, rnames) = party r in
      (lfun + rfun, lnames @ rnames)
