(* A specification of an immutable stack of elements of type 'a. *)

module type STACK = sig
  type 'a stack
  exception EmptyStack
  val empty : 'a stack
  val is_empty : 'a stack -> bool
  val push : 'a -> 'a stack -> 'a stack
  val pop : 'a stack -> 'a * 'a stack
  val map : ('a -> 'b) -> 'a stack -> 'b stack
end

(* An implementation using lists, where the top of the stack is
 * represented by the head of the list. *)

module Stack : STACK = struct
  type 'a stack = 'a list
  exception EmptyStack

  let empty = []
  let is_empty l = l = []
  let push x l = x :: l

  let pop l =
    match l with
    | [] -> raise EmptyStack
    | x :: xs -> (x, xs)

  let map = List.map
end
