{
open Parser
}

let lowercase = ['a'-'z']
let uppercase = ['A'-'Z']
let alphanumeric = ['a'-'z' 'A'-'Z' '0'-'9']*
rule token = parse
  | [' ' '\t'] { token lexbuf } (* skip blanks *)
  | ['\n'] { EOL }
  | lowercase alphanumeric as id { FUN id }
  | uppercase alphanumeric as id { REL id }
  | '0'    { FALSE }
  | '1'    { TRUE }
  | '&'    { AND }
  | '|'    { OR }
  | '~'    { NOT }
  | "->"   { IMP }
  | "<->"  { IFF }
  | '#'    { EXISTS }
  | '@'    { FORALL }
  | '('    { LPAREN }
  | ')'    { RPAREN }
  | ','    { COMMA }
  | '.'    { DOT }
  | eof    { EOL }
