
let read_file (filename : string) : string list =
  let in_channel = open_in filename in
  let rec read_lines (s : string list) : string list =
    let next = try Some (input_line in_channel) with End_of_file -> None in
    match next with Some x -> read_lines (x :: s) | None -> s in
  read_lines []

let output_endline (ch : out_channel) (s : string) : unit =
  output_string ch s; output_char ch '\n'

let write_file (filename : string) (s : string list) : unit =
  let out_channel = open_out filename in
  List.iter (output_endline out_channel) s

let rec transpose l =
  match l with
    | [] -> []
    | [x] -> List.map (fun y -> [y]) x
    | x :: t -> List.map2 (fun y u -> y :: u) x (transpose t)

let rec map3 f x y z =
  match x, y, z with
    | [], [], [] -> []
    | hx :: tx, hy :: ty, hz :: tz -> f hx hy hz :: map3 f tx ty tz
    | _ -> failwith "length error"
