open Util
open Command
open State

(* read eval print loop *)
let rec repl (state : state) : unit =
  let recover (error : string) : state =
    print_endline error;
    if !undo_stack = [] || List.hd !undo_stack <> state then ()
    else undo_stack := List.tl !undo_stack;
    state in
  print_string "? ";
  let state =
    try
      let input = read_line() in
      do_command input state
    with Failure s -> recover ("Error: " ^ s)
      | Parsing.Parse_error -> recover "Parse Error"
  in
  print_endline "================================================";
  print_endline (State.to_string state);
  repl state
  
and prove (expr : Ast.formula) : unit =
  let state = start_state expr in
  print_endline (State.to_string state);
  try repl state
  with Quit -> print_endline "bye"
  | Reset -> prove expr
  | Init -> print_endline ""; init()

and init () : unit =
  print_endline "Enter theorem:";
  let input = read_line() in
  if input = "" then print_endline "bye" else
  try 
    let expr = parse_formula input in
    prove expr
  with Failure s -> print_endline ("Error: " ^ s); init()
  | Parsing.Parse_error -> print_endline "Parse error"; init()

let _ = init ()
