%{
open Ast
%}

%token <string> FUN
%token <string> REL
%token TRUE FALSE
%token AND OR NOT
%token IMP IFF
%token EXISTS FORALL
%token LPAREN RPAREN COMMA DOT
%token EOL

%left IFF     /* lowest precedence */
%right IMP
%left OR
%left AND TRUE FALSE LPAREN
%nonassoc NOT EXISTS FORALL /* highest precedence */

%start parse_formula parse_term /* entry points */
%type <Ast.formula> parse_formula
%type <Ast.term> parse_term

%%

parse_formula:
  | formula EOL { $1 }

parse_term:
  | term EOL { $1 }

termlist:
  | term                 { [$1] }
  | term COMMA termlist  { $1 :: $3 }
;

term:
  | FUN LPAREN termlist RPAREN { Term ($1, $3) }
  | FUN                        { Term ($1, []) }
;

relation:
  | REL LPAREN termlist RPAREN { Rel ($1, $3) }
  | REL                        { Rel ($1, []) }
;

formula:
  | relation              { $1 }
  | FALSE                 { False }
  | TRUE                  { True }
  | LPAREN formula RPAREN { $2 }
  | formula AND formula   { And ($1, $3) }
  | formula OR formula    { Or ($1, $3) }
  | formula IMP formula   { Imp ($1, $3) }
  | formula IFF formula   { Iff ($1, $3) }
  | EXISTS FUN DOT formula %prec EXISTS { Exists ($2, $4) }
  | FORALL FUN DOT formula %prec FORALL { Forall ($2, $4) }
  | NOT formula %prec NOT { Not $2 }
;

%%


