/*
 *  MultipleCatches.cpp
 */

#include <iostream>

using namespace std;  //introduces namespace std

// Some miscellaneous error codes
enum {
  noErr,
  divByZero,
  badIndex
};

// A simple divide operation which catches div by 0
float divide(int arg1,int arg2)
{
  if (arg2 == 0)
    throw (int) divByZero;
    
  return arg1/arg2;
}

// A VERY simple integer array which does range checking
template<int storageSize>
class MyIntArray
{
public:
  int &operator[](int i);
private:
  int arrayValues[storageSize];
};

template<int storageSize>
int &MyIntArray<storageSize>::operator[](int i)
{
  if ((i < 0) || (i >= storageSize))
    throw (int) badIndex;
  return arrayValues[i];
}

// Define global data
MyIntArray<5> globalIntArray;


// func2 does the division and traps divide by zero errors
void func2()
{
  float f;
  try {
    f = divide(globalIntArray[15334],globalIntArray[1]);
    cout << "f = " << f << endl;
  } catch(int x) {
    if (x == divByZero)
      cerr << "Divide by zero caught! " << endl;
    else
      cout << "Generic exception caught: " << x << endl;
  }
}

// func 1 calls the function which does the division, catches bad index 
// exceptions
void func1()
{
  try {
    func2();
  } catch(int x) {
    if (x == badIndex)
      cerr << "Error, bad index encountered" << endl;
    else
      cerr << "Generic exception caught: " << x << endl;
  }
}

int main()
{	
    for (int i=0; i<5; i++)
      globalIntArray[i] = i;
      
    func1();
	return 0;
}

