//
// GUIMessage.cpp
//
// A simple class which "implements" a UserMessage with a simple
// MacOS alert message approach
//


#include <iostream>
#include <fstream>


#include "GUIMessage.h"

void c2pstr(char *buffer)
{
  int len = strlen(buffer);
  for (int i=len; i>0; i--)
    buffer[i] = buffer[i-1];
	
  buffer[0] = (char) len;
}

void GUIMessage::ShowMessage(string message)
{
  short itemHit;
  char *theMessage = message.c_str();
  c2pstr(theMessage);
  
  StandardAlert(kAlertStopAlert,"\pAn Error Occurred",
               (StringPtr)theMessage,NULL,&itemHit);
	
}


void GUIMessage::SetLogFile(string filename)
{
  logfilename = filename;
}


void GUIMessage::LogMessage(string message)
{
  ofstream os(logfilename.c_str());
  if (os.is_open())
    os << message;
}

  
