/*
 *  Dealership.h
 *  Assignment 03
 *
 *  Created by Ron DiNapoli on Mon Sep 06 2004.
 *  
 */
#include <iostream>
using namespace std;

// We'll need the automobile class
#include "Vehicle.h"

class Dealership
{
public:
  // Initialize gives us a way to set the pointer and counter
  // variables to 0 so that we know we have just started out
  // (no dynamically allocated memory yet)
  Dealership()
  {
    mNumVehicles = 0;
	mVehicleIndex = 0;
	mVehicles = 0;
  }
  
  Dealership(int count)
  {
    mNumVehicles = count;
	mVehicleIndex = 0;
	mVehicles = new (Vehicle *)[count];
  }

  // setInventoryCount() is used to dynamically allocate 
  // memory for the specified number of vehicles. Returns 
  // true if everything was allocated properly, false if not.
  bool setInventoryCount(int count);
  
  // addToInventory() allows us to add a new vehicle to the
  // inventory.  Returns true if the add succeeded, false 
  // if not (if the inventory was already filled up)
  bool addToInventory(Vehicle *newVehicle);
					  
  // displayInventory() prints out the inventory on hand
  void displayInventory();
  
  // freeInventory() is used to free the memory dynamically
  // allocated to store our inventory
  void freeInventory();
  
private:
  Vehicle **mVehicles;    // a dynamic array of Vehicles
  int mNumVehicles;       // the maximum size of our inventory
  int mVehicleIndex;      // the number of vehicles in our inventory
};

