/*
 *  Dealership.cpp
 *  Assignment 03
 *
 *  Created by Ron DiNapoli on Mon Sep 06 2004.
 *  
 */

#include <iostream>

using namespace std;

#include "Vehicle.h"
#include "Boat.h"
#include "Automobile.h"
#include "Bicycle.h"
#include "Dealership.h"
//
// Dealership::setInventoryCount() allows us to dynamically 
// allocate memory to hold our inventory.  If there was 
// previously allocated memory in our inventory, we delete it
//
bool Dealership::setInventoryCount(int count)
{
  Vehicle **newVehicles;
  
  // Make sure we've asked for a valid inventory size
  if (count < 1)
  {
	cout << "Error, invalid inventory count " << endl;
	return false;
  }
  
  // Allocate new memory for the inventory size requested
  newVehicles = new (Vehicle *)[count];
  
  // Make sure we were able to allocate memory
  if (!newVehicles)
  {
    cout << "Error allocating memory for inventory " << endl;
	return false;
  }
  
  // If there was previously allocated memory, delete it
  if (mVehicles)
    delete [] mVehicles;
	
  // Set the internal dynamic array pointer equal to the 
  // memory we just allocated for the inventory
  mVehicles = newVehicles;
  
  // Note the new maximum inventory size
  mNumVehicles = count;
  
  // Set the total number of vehicles in the inventory to zero
  mVehicleIndex = 0;
  return true;
}

// Dealership::addToInventory() allows us to add a new vehicle 
// into the inventory (if there is space available)
bool Dealership::addToInventory(Vehicle *newVehicle)
{
  // Make sure there is space available in the inventory
  if (mVehicleIndex >= mNumVehicles)
  {
    cout << "Error: no room left in inventory " << endl;
	return false;
  }
  
  // Set the attributes of the vehicle we are adding to the 
  // inventory, and increment the count of the number of vehicles
  // in the inventory
  mVehicles[mVehicleIndex++]=newVehicle;
  return true;
}

//
// Dealership::displayInventory() gives us a way to display
// the contents of the inventory.  It makes use of the 
// Automobile::display() method to print out data about each
// individual vehicle
//
void Dealership::displayInventory()
{
  cout << "DEALER INVENTORY " << endl;
  cout << "=============================================" << endl;
  for (int i=0; i<mVehicleIndex; i++)
  {
    // Print out the "slot number" of this vehicle
    cout << i+1 << ". ";
	
	// Print out data about the vehicle
	(mVehicles[i])->printVehicleType();
	cout << endl;
	(mVehicles[i])->printDescription();  
	cout << endl;
  }
}

//
// Dealership::freeInventory() allows us to free all dynamically
// allocated memory for our inventory.  We make sure that the
// dynamic array pointer is set to 0 as well as the two "count"
// member variables.
//
void Dealership::freeInventory()
{
  // Delete all of the individual objects first
  for (int i=0; i<mVehicleIndex; i++)
  {
	delete mVehicles[i];
  }
  
  // Make sure there is memory allocated before freeing
  if (mVehicles)
    delete [] mVehicles;
	
  // Set all member variables back to 0
  mVehicles = 0;
  mVehicleIndex = 0;
  mNumVehicles = 0;
}
