/*
 *  Dealership.h
 *  Assignment 03
 *
 *  Created by Ron DiNapoli on Mon Sep 06 2004.
 *  
 */
#include <iostream>
using namespace std;

// We'll need the automobile class
#include "Automobile.h"

class Dealership
{
public:
  // Initialize gives us a way to set the pointer and counter
  // variables to 0 so that we know we have just started out
  // (no dynamically allocated memory yet)
  void initialize()
  {
    mNumAutos = 0;
	mAutoIndex = 0;
	mAutos = 0;
  }
  
  // setInventoryCount() is used to dynamically allocate 
  // memory for the specified number of vehicles. Returns 
  // true if everything was allocated properly, false if not.
  bool setInventoryCount(int count);
  
  // addToInventory() allows us to add a new vehicle to the
  // inventory.  Returns true if the add succeeded, false 
  // if not (if the inventory was already filled up)
  bool addToInventory(string make, string model, string year,
                      int mileage, float price);
					  
  // displayInventory() prints out the inventory on hand
  void displayInventory();
  
  // freeInventory() is used to free the memory dynamically
  // allocated to store our inventory
  void freeInventory();
  
private:
  Automobile *mAutos;  // a dynamic array of Automobiles
  int mNumAutos;       // the maximum size of our inventory
  int mAutoIndex;      // the number of vehicles in our inventory
};

