//
// CS213 Fall 2004
// Assignment #2: OurApp class
//

#include <iostream>

// This is needed to access many of the standard symbols/functions in C++
using namespace std;

// "OurApp" is the name of our new class.  
class OurApp
{
public:
	// The only public function is the one which kicks off the program
	void run();

private:
	void readValues();			// Read values from user
	void printMenu();			// Present menu to user
	int getUserChoice();		// Get valid choice from user
	
	void addNumbers();			// Implement add numbers function
	void averageNumbers();		// Implement average function
	void largestNumber();		// Find the largest number
	void smallestNumber();		// Find the smallest number
	
private:
	// The five values read in from the user
	int val1, val2, val3, val4, val5;
	
	// The choice made by the user
	int choice;
};


void OurApp::readValues()
{
	// Prompt the user for 5 numbers, then read them in
	cout << "Please enter 5 integers: " << endl;
	cout << "1: ";   cin >> val1;
	cout << "2: ";   cin >> val2;
	cout << "3: ";   cin >> val3;
	cout << "4: ";   cin >> val4;
	cout << "5: ";   cin >> val5;
}

void OurApp::printMenu()
{
	// Display menu
	cout << "MAIN MENU" << endl;
	cout << "1>  Add the numbers " << endl;
	cout << "2>  Average the numbers " << endl;
	cout << "3>  Find the largest number " << endl;
	cout << "4>  Find the smallest number " << endl;
	cout << "5>  Quit " << endl << endl;
}


int OurApp::getUserChoice()
{
	for(;;)
	{
	  cout << "Enter choice> ";

	  // read in choice
	  cin >> choice;
	  if ((choice > 0) && (choice < 6))
		break;
		
	  cout << "Please enter a number from 1 - 5 " << endl;
	}
	
	return choice;
}

void OurApp::run()
{
	// Get values from  user
	readValues();
	choice = 0;
	
	// Loop until quit (5) is chosen
	while (choice != 5)
	{
		// Present the user with a menu
		printMenu();
		
		// Get user choice from menu
		getUserChoice();
		
		// take appropriate action
		switch( choice )
		{
			case 1:
				addNumbers();
				break;
			case 2: 
				averageNumbers();
				break;
			case 3:
				largestNumber();
				break;
			case 4:
				smallestNumber();
		}
	}
	
	cout << "Thanks for using our program! " << endl;
}


// Implements the "Add Numbers" function
void OurApp::addNumbers()
{
	cout << "Sum of numbers is: " << val1 + val2 + val3 + val4 + val5 << endl;
}

// Implements the "Average Numbers" function
void OurApp::averageNumbers()
{
	cout << "Average of numbers is: " << (val1 + val2 + val3 + val4 + val5)/5 << endl;
}

// Finds the largest number of the five entered
void OurApp::largestNumber()
{
	int largest;
	
	// Look for largest number and print out the result
	largest = val1;
	if (val2 > largest) 
		largest = val2;
	if (val3 > largest) 
		largest = val3;
	if (val4 > largest) 
		largest = val4;
	if (val5 > largest) 
		largest = val5;
	cout << "Largest is " << largest << endl;
}

// Finds the smallest number of the ones entered
void OurApp::smallestNumber()
{
	int smallest;
	
	// Look for smallest number and print out the result
	smallest = val1;
	if (val2 < smallest) 
		smallest = val2;
	if (val3 < smallest) 
		smallest = val3;
	if (val4 < smallest) 
		smallest = val4;
	if (val5 < smallest) 
		smallest = val5;
	cout << "Smallest is " << smallest << endl;
}


// Here's our main function
int main (int argc, char * const argv[]) {
	OurApp oa;
	
	// run the app!
	oa.run();
	return 0;
}
